/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.channel.framework.impl.ConnectionDescriptorImpl;
import com.ibm.ws.tcp.channel.impl.NioSocketIOChannel;
import com.ibm.ws.tcp.channel.impl.SimpleSync;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.WorkQueueManager;
import com.ibm.wsspi.channel.framework.ConnectionDescriptor;
import com.ibm.wsspi.tcp.channel.TCPConfigConstants;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ConnectionManager
implements TCPConfigConstants {
    static final TraceComponent tc = Tr.register(ConnectionManager.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");
    static final String CLASS_NAME = "com.ibm.ws.tcp.channel.impl.ConnectionManager";
    private WorkQueueManager workQueueMgr = null;
    private TCPChannel tcpChannel = null;
    private TCPChannelConfiguration tcpConfig = null;

    public ConnectionManager(TCPChannel tCPChannel, WorkQueueManager workQueueManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ConnectionManager");
        }
        this.tcpChannel = tCPChannel;
        this.tcpConfig = this.tcpChannel.getConfig();
        this.workQueueMgr = workQueueManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ConnectionManager");
        }
    }

    SocketIOChannel getConnection(TCPConnectRequestContext tCPConnectRequestContext, TCPConnLink tCPConnLink, SimpleSync simpleSync) throws IOException {
        boolean bl = false;
        ConnectInfo connectInfo = null;
        SocketIOChannel socketIOChannel = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnection for local: " + tCPConnectRequestContext.getLocalAddress() + ", remote: " + tCPConnectRequestContext.getRemoteAddress() + ", timeout: " + tCPConnectRequestContext.getConnectTimeout());
        }
        socketIOChannel = this.create(tCPConnectRequestContext.getLocalAddress(), tCPConnLink);
        tCPConnLink.setSocketIOChannel(socketIOChannel);
        if (this.tcpConfig.getBlockingChannel() == 1) {
            StartPrivilegedThread startPrivilegedThread = new StartPrivilegedThread(socketIOChannel.getSocket(), tCPConnectRequestContext.getRemoteAddress());
            ConnectReturn connectReturn = (ConnectReturn)AccessController.doPrivileged(startPrivilegedThread);
            if (connectReturn.ioe != null) {
                throw connectReturn.ioe;
            }
            socketIOChannel.initStreams();
            tCPConnLink.setCallCompleteLocal(true);
            return socketIOChannel;
        }
        bl = socketIOChannel.connect(tCPConnectRequestContext.getRemoteAddress());
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "obtained connection without queuing to selector");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnection");
            }
            tCPConnLink.setCallCompleteLocal(true);
            return socketIOChannel;
        }
        connectInfo = new ConnectInfo(tCPConnectRequestContext, tCPConnLink, this, socketIOChannel);
        connectInfo.timeout = tCPConnectRequestContext.getConnectTimeout();
        if (simpleSync != null) {
            connectInfo.setSyncObject(simpleSync);
        }
        connectInfo.setFinish();
        this.workQueueMgr.queueConnectForSelector(connectInfo);
        if (simpleSync != null) {
            boolean bl2 = false;
            while (!bl2) {
                simpleSync.simpleWait();
                bl2 = this.workQueueMgr.attemptConnectWork(connectInfo);
            }
            if (connectInfo.getAction() == 3) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConnection");
                }
                return socketIOChannel;
            }
            if (connectInfo.getError() == null) {
                connectInfo.setError(new IOException("Connection could not be established"));
            }
            throw connectInfo.getError();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnection");
        }
        return null;
    }

    private SocketIOChannel create(InetSocketAddress inetSocketAddress, TCPConnLink tCPConnLink) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        Socket socket = null;
        SocketIOChannel socketIOChannel = null;
        if (this.tcpConfig.getBlockingChannel() == 0) {
            socketIOChannel = this.tcpChannel.createOutboundSocketIOChannel();
            socket = socketIOChannel.getSocket();
        } else {
            socket = new Socket();
            socketIOChannel = NioSocketIOChannel.createIOChannel(socket, this.tcpChannel);
        }
        if (this.tcpConfig.getSoReuseAddress() == 0) {
            socket.setReuseAddress(false);
        } else {
            socket.setReuseAddress(true);
        }
        if (this.tcpConfig.getReceiveBufferSize() >= 4 && this.tcpConfig.getReceiveBufferSize() <= 0x1000000) {
            socket.setReceiveBufferSize(this.tcpConfig.getReceiveBufferSize());
        }
        if (this.tcpConfig.getSendBufferSize() >= 4 && this.tcpConfig.getSendBufferSize() <= 0x1000000) {
            socket.setSendBufferSize(this.tcpConfig.getSendBufferSize());
        }
        if (inetSocketAddress != null) {
            try {
                socket.bind(inetSocketAddress);
                InetAddress inetAddress = inetSocketAddress.getAddress();
                if (inetAddress != null) {
                    ConnectionDescriptor connectionDescriptor = tCPConnLink.getVirtualConnection().getConnectionDescriptor();
                    if (connectionDescriptor != null) {
                        connectionDescriptor.setAddrs(null, inetAddress);
                    } else {
                        ConnectionDescriptorImpl connectionDescriptorImpl = new ConnectionDescriptorImpl(null, inetAddress);
                        tCPConnLink.getVirtualConnection().setConnectionDescriptor(connectionDescriptorImpl);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "bound connection: " + tCPConnLink.getVirtualConnection().getConnectionDescriptor());
                    }
                }
            }
            catch (IOException iOException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bind error making outbound connection " + iOException);
                }
                FFDCFilter.processException((Throwable)iOException, CLASS_NAME, "100", this);
                throw iOException;
            }
        }
        if (this.tcpConfig.getSoLinger() >= 0) {
            socket.setSoLinger(true, this.tcpConfig.getSoLinger());
        } else {
            socket.setSoLinger(false, 0);
        }
        if (this.tcpConfig.getKeepAlive() == 0) {
            socket.setKeepAlive(false);
        } else {
            socket.setKeepAlive(true);
        }
        if (this.tcpConfig.getTcpNoDelay() == 0) {
            socket.setTcpNoDelay(false);
        } else {
            socket.setTcpNoDelay(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Socket created, local port: " + socket.getLocalPort());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        return socketIOChannel;
    }

    protected class ConnectInfo {
        protected InetSocketAddress localAddress;
        protected InetSocketAddress remoteAddress;
        protected TCPConnLink tcpConnLink;
        protected SocketIOChannel ioSocket;
        protected SocketChannel channel;
        protected ConnectionManager connMgr;
        protected IOException errorException = null;
        protected SimpleSync syncObject = null;
        protected int timeout = -1;
        protected long nextTimeoutTime = 0L;
        public static final int GET_CONNECTION = 0;
        public static final int FINISH_CONNECTION = 1;
        public static final int CALL_ERROR = 2;
        public static final int FINISH_COMPLETE = 3;
        protected int action = 0;

        protected ConnectInfo(TCPConnectRequestContext tCPConnectRequestContext, TCPConnLink tCPConnLink, ConnectionManager connectionManager2, SocketIOChannel socketIOChannel) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "ConnectInfo");
            }
            this.localAddress = tCPConnectRequestContext.getLocalAddress();
            this.remoteAddress = tCPConnectRequestContext.getRemoteAddress();
            this.tcpConnLink = tCPConnLink;
            this.connMgr = connectionManager2;
            this.ioSocket = socketIOChannel;
            this.channel = this.ioSocket != null ? this.ioSocket.getChannel() : null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "ConnectInfo");
            }
        }

        protected int getAction() {
            return this.action;
        }

        protected void setError(IOException iOException) {
            this.action = 2;
            this.errorException = iOException;
        }

        protected IOException getError() {
            return this.errorException;
        }

        protected void setFinish() {
            this.action = 1;
        }

        protected void setFinishComplete() {
            this.action = 3;
        }

        protected void setSyncObject(SimpleSync simpleSync) {
            this.syncObject = simpleSync;
        }

        protected SimpleSync getSyncObject() {
            return this.syncObject;
        }
    }

    class StartPrivilegedThread
    implements PrivilegedAction {
        Socket ioSocket;
        InetSocketAddress address;

        public StartPrivilegedThread(Socket socket, InetSocketAddress inetSocketAddress) {
            this.ioSocket = socket;
            this.address = inetSocketAddress;
        }

        public Object run() {
            ConnectReturn connectReturn = new ConnectReturn();
            try {
                this.ioSocket.connect(this.address);
            }
            catch (IOException iOException) {
                connectReturn.ioe = iOException;
            }
            return connectReturn;
        }
    }

    public class ConnectReturn {
        public IOException ioe = null;
    }
}

