/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.channel.framework.impl.ConnectionDescriptorImpl;
import com.ibm.ws.tcp.channel.impl.ConnectionManager;
import com.ibm.ws.tcp.channel.impl.SimpleSync;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPChannelDiagnosticModule;
import com.ibm.ws.tcp.channel.impl.TCPProxyConnLink;
import com.ibm.ws.tcp.channel.impl.TCPProxyResponse;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.TCPWriteRequestContextImpl;
import com.ibm.wsspi.channel.InboundConnectionLink;
import com.ibm.wsspi.channel.OutboundConnectionLink;
import com.ibm.wsspi.channel.framework.ConnectionDescriptor;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;

public class TCPConnLink
extends TCPProxyConnLink
implements InboundConnectionLink,
OutboundConnectionLink,
TCPConnectionContext {
    private TCPChannelConfiguration config;
    private TCPChannel tcpChannel = null;
    private boolean pleaseCloseSoon;
    private int numReads = 0;
    private int numWrites = 0;
    private ThreadPool oThreadPool;
    private TCPReadRequestContextImpl reader;
    private TCPWriteRequestContextImpl writer;
    public static final String TCP_READ_CONTEXT = "TCP_READ_CONTEXT";
    public static final String TCP_WRITE_CONTEXT = "TCP_WRITE_CONTEXT";
    private SocketIOChannel socketIOChannel;
    protected SimpleSync syncObject = null;
    protected IOException syncError = null;
    TCPProxyResponse proxy = null;
    private int channelBlockingType = 0;
    private boolean callCompleteLocal = false;
    private boolean closed = false;
    private int inUseIndex = 0;
    protected static final TraceComponent tc = Tr.register(TCPConnLink.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    public TCPConnLink(VirtualConnection virtualConnection, TCPChannel tCPChannel, TCPChannelConfiguration tCPChannelConfiguration, ThreadPool threadPool, int n) {
        this.init(virtualConnection);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TCPConnLink");
        }
        this.inUseIndex = n;
        this.tcpChannel = tCPChannel;
        this.config = tCPChannelConfiguration;
        this.oThreadPool = threadPool;
        this.channelBlockingType = tCPChannelConfiguration.getBlockingChannel();
        this.reader = tCPChannel.createReadInterface(this);
        this.writer = tCPChannel.createWriteInterface(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TCPConnLink");
        }
    }

    protected ThreadPool getThreadPool() {
        return this.oThreadPool;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void ready(VirtualConnection virtualConnection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "This should not be called because the TCPConnLink is always ready since it is the first in the chain.");
        }
    }

    public Object getChannelAccessor() {
        return this;
    }

    public TCPChannel getTCPChannel() {
        return this.tcpChannel;
    }

    public TCPReadRequestContext getReadInterface() {
        return this.reader;
    }

    public TCPWriteRequestContext getWriteInterface() {
        return this.writer;
    }

    protected TCPReadRequestContextImpl getTCPReadConnLink() {
        return this.reader;
    }

    protected TCPWriteRequestContextImpl getTCPWriteConnLink() {
        return this.writer;
    }

    public void connect(Object object) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connect");
        }
        if (!this.config.isDispatchWorkToThreads()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Can't perform sync connect. Dispatch to Worker threads = false");
            }
            throw new IOException("Can't perform sync connect. Dispatch to Worker threads = false");
        }
        this.syncObject = new SimpleSync();
        if (this.proxy != null) {
            this.proxy.setIsProxyResponseValid(false);
        }
        this.syncError = null;
        this.connectCommon((TCPConnectRequestContext)object);
        if (this.syncError != null) {
            throw this.syncError;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connect");
        }
    }

    public void connectAsynch(Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connectAsynch");
        }
        this.syncObject = null;
        if (this.channelBlockingType == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "SocketChannel: ConnectAsynch failed, can not call connectAsynch on a Blocking Channel ");
            }
            IOException iOException = new IOException("ConnectAsynch failed, can not call connectAsynch on a Blocking Channel ");
            this.connectFailed(iOException);
        } else {
            if (this.proxy != null) {
                this.proxy.setIsProxyResponseValid(false);
            }
            this.connectCommon((TCPConnectRequestContext)object);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connectAsynch");
        }
    }

    public void connectCommon(TCPConnectRequestContext tCPConnectRequestContext) {
        ConnectionManager connectionManager = this.tcpChannel.getConnMgr();
        TCPConnectRequestContext tCPConnectRequestContext2 = tCPConnectRequestContext;
        SocketIOChannel socketIOChannel = null;
        if (this.socketIOChannel != null) {
            this.socketIOChannel.close();
            this.socketIOChannel = null;
        }
        try {
            this.callCompleteLocal = false;
            socketIOChannel = connectionManager.getConnection(tCPConnectRequestContext2, this, this.syncObject);
            if (this.callCompleteLocal) {
                this.connectComplete(socketIOChannel);
            }
        }
        catch (IOException iOException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "SocketChannel connect failed, local: " + tCPConnectRequestContext2.getLocalAddress() + " remote: " + tCPConnectRequestContext2.getRemoteAddress());
            }
            this.connectFailed(iOException);
        }
    }

    protected void connectComplete(SocketIOChannel socketIOChannel) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connectComplete");
        }
        this.setSocketIOChannel(socketIOChannel);
        Socket socket = socketIOChannel.getSocket();
        InetAddress inetAddress = socket.getInetAddress();
        InetAddress inetAddress2 = socket.getLocalAddress();
        ConnectionDescriptor connectionDescriptor = this.vc.getConnectionDescriptor();
        if (connectionDescriptor != null) {
            connectionDescriptor.setAddrs(inetAddress, inetAddress2);
        } else {
            ConnectionDescriptorImpl connectionDescriptorImpl = new ConnectionDescriptorImpl(inetAddress, inetAddress2);
            this.vc.setConnectionDescriptor(connectionDescriptorImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Connection Complete for: " + this.vc.getConnectionDescriptor());
        }
        int n = this.vc.attemptToSetFileChannelCapable(2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "FileChannelCapable set in VC to: " + n);
        }
        socketIOChannel.connectActions();
        Object v = this.getVirtualConnection().getStateMap().get("FORWARD_PROXY_CONNECT");
        if (null != v) {
            if (this.proxy == null) {
                this.proxy = new TCPProxyResponse(this);
            }
            boolean bl = false;
            try {
                bl = this.proxy.setForwardProxyBuffers((Map)v);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException(classCastException, "com.ibm.ws.tcp.channel.impl.TCPConnLink.connectComplete", "300");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Incorrect forward proxy setup: " + classCastException);
                }
                this.connectFailed(new IOException(classCastException.getMessage()));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "connectComplete");
                }
                return;
            }
            if (bl) {
                this.proxy.writeAndShake();
            }
        } else if (this.syncObject == null) {
            this.getApplicationCallback().ready(this.getVirtualConnection());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connectComplete");
        }
    }

    protected boolean isAsyncConnect() {
        return null == this.syncObject;
    }

    protected boolean isSyncError() {
        return null != this.syncError;
    }

    protected void setCallCompleteLocal(boolean bl) {
        this.callCompleteLocal = bl;
    }

    protected void connectFailed(IOException iOException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "connectFailed");
        }
        if (this.socketIOChannel != null) {
            this.socketIOChannel.close();
            this.socketIOChannel = null;
        }
        if (this.isAsyncConnect()) {
            this.close(this.getVirtualConnection(), iOException);
        } else {
            this.syncError = iOException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "connectFailed");
        }
    }

    protected void setSocketIOChannel(SocketIOChannel socketIOChannel) {
        this.socketIOChannel = socketIOChannel;
    }

    public SocketIOChannel getSocketIOChannel() {
        return this.socketIOChannel;
    }

    public TCPChannelConfiguration getConfig() {
        return this.config;
    }

    public InetAddress getRemoteAddress() {
        return this.socketIOChannel.getSocket().getInetAddress();
    }

    public int getRemotePort() {
        return this.socketIOChannel.getSocket().getPort();
    }

    public InetAddress getLocalAddress() {
        return this.socketIOChannel.getSocket().getLocalAddress();
    }

    public int getLocalPort() {
        return this.socketIOChannel.getSocket().getLocalPort();
    }

    public SSLConnectionContext getSSLContext() {
        return null;
    }

    protected int getNumReads() {
        return this.numReads;
    }

    protected int getNumWrites() {
        return this.numWrites;
    }

    public void incrementNumReads() {
        ++this.numReads;
    }

    public void incrementNumWrites() {
        ++this.numWrites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(VirtualConnection virtualConnection, Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "close(), " + this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            try {
                if (virtualConnection != null) {
                    Tr.debug(tc, "Closing the connection: " + virtualConnection.getConnectionDescriptor());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        boolean bl = true;
        TCPConnLink tCPConnLink = this;
        synchronized (tCPConnLink) {
            if (this.closed) {
                bl = false;
            }
            this.closed = true;
        }
        if (bl) {
            super.close(virtualConnection, exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "close()");
        }
    }

    public void destroy(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            if (exception == null) {
                Tr.entry(tc, "destroy(null)");
            } else {
                Tr.entry(tc, "destroy(Exc) " + exception.getMessage());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.vc.getConnectionDescriptor() != null) {
            Tr.debug(tc, "Destroying the connection: " + this.vc.getConnectionDescriptor());
        }
        if (this.socketIOChannel != null) {
            this.socketIOChannel.close();
            this.tcpChannel.decrementConnectionCount();
        }
        this.socketIOChannel = null;
        this.reader = null;
        this.writer = null;
        super.destroy(exception);
        this.tcpChannel.releaseConnectionLink(this, this.inUseIndex);
        if (exception == null) {
            Tr.exit(tc, "destroy(null)");
        } else {
            Tr.exit(tc, "destroy(Exc)");
        }
    }

    protected String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer == null ? new StringBuffer() : stringBuffer;
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("pleaseCloseSoon", String.valueOf(this.pleaseCloseSoon), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("getLocalAddress()", String.valueOf(this.getLocalAddress()), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("getLocalPort()", String.valueOf(this.getLocalPort()), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("getRemoteAddress()", String.valueOf(this.getRemoteAddress()), stringBuffer2);
        stringBuffer2 = TCPChannelDiagnosticModule.formatFFDCString("getRemotePort()", String.valueOf(this.getRemotePort()), stringBuffer2);
        return stringBuffer2.toString();
    }

    protected String getFFDCDumpData() {
        return this.getFFDCDumpData(null);
    }
}

