/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.grpc.internal;

import com.alibaba.nacos.shaded.com.google.common.annotations.VisibleForTesting;
import com.alibaba.nacos.shaded.com.google.common.base.MoreObjects;
import com.alibaba.nacos.shaded.com.google.common.base.Objects;
import com.alibaba.nacos.shaded.com.google.common.base.Preconditions;
import com.alibaba.nacos.shaded.com.google.common.base.Verify;
import com.alibaba.nacos.shaded.com.google.common.base.VerifyException;
import com.alibaba.nacos.shaded.com.google.common.math.LongMath;
import com.alibaba.nacos.shaded.io.grpc.Status;
import com.alibaba.nacos.shaded.io.grpc.internal.RetriableStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class ServiceConfigUtil {
    private static final String SERVICE_CONFIG_METHOD_CONFIG_KEY = "methodConfig";
    private static final String SERVICE_CONFIG_LOAD_BALANCING_POLICY_KEY = "loadBalancingPolicy";
    private static final String SERVICE_CONFIG_LOAD_BALANCING_CONFIG_KEY = "loadBalancingConfig";
    private static final String XDS_CONFIG_BALANCER_NAME_KEY = "balancerName";
    private static final String XDS_CONFIG_CHILD_POLICY_KEY = "childPolicy";
    private static final String XDS_CONFIG_FALLBACK_POLICY_KEY = "fallbackPolicy";
    private static final String SERVICE_CONFIG_STICKINESS_METADATA_KEY = "stickinessMetadataKey";
    private static final String METHOD_CONFIG_NAME_KEY = "name";
    private static final String METHOD_CONFIG_TIMEOUT_KEY = "timeout";
    private static final String METHOD_CONFIG_WAIT_FOR_READY_KEY = "waitForReady";
    private static final String METHOD_CONFIG_MAX_REQUEST_MESSAGE_BYTES_KEY = "maxRequestMessageBytes";
    private static final String METHOD_CONFIG_MAX_RESPONSE_MESSAGE_BYTES_KEY = "maxResponseMessageBytes";
    private static final String METHOD_CONFIG_RETRY_POLICY_KEY = "retryPolicy";
    private static final String METHOD_CONFIG_HEDGING_POLICY_KEY = "hedgingPolicy";
    private static final String NAME_SERVICE_KEY = "service";
    private static final String NAME_METHOD_KEY = "method";
    private static final String RETRY_POLICY_MAX_ATTEMPTS_KEY = "maxAttempts";
    private static final String RETRY_POLICY_INITIAL_BACKOFF_KEY = "initialBackoff";
    private static final String RETRY_POLICY_MAX_BACKOFF_KEY = "maxBackoff";
    private static final String RETRY_POLICY_BACKOFF_MULTIPLIER_KEY = "backoffMultiplier";
    private static final String RETRY_POLICY_RETRYABLE_STATUS_CODES_KEY = "retryableStatusCodes";
    private static final String HEDGING_POLICY_MAX_ATTEMPTS_KEY = "maxAttempts";
    private static final String HEDGING_POLICY_HEDGING_DELAY_KEY = "hedgingDelay";
    private static final String HEDGING_POLICY_NON_FATAL_STATUS_CODES_KEY = "nonFatalStatusCodes";
    private static final long DURATION_SECONDS_MIN = -315576000000L;
    private static final long DURATION_SECONDS_MAX = 315576000000L;
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);

    private ServiceConfigUtil() {
    }

    @Nullable
    public static String getHealthCheckedServiceName(@Nullable Map<String, ?> serviceConfig) {
        String healthCheckKey = "healthCheckConfig";
        String serviceNameKey = "serviceName";
        if (serviceConfig == null || !serviceConfig.containsKey(healthCheckKey)) {
            return null;
        }
        Map<String, ?> healthCheck = ServiceConfigUtil.getObject(serviceConfig, healthCheckKey);
        if (!healthCheck.containsKey(serviceNameKey)) {
            return null;
        }
        return ServiceConfigUtil.getString(healthCheck, "serviceName");
    }

    @Nullable
    static RetriableStream.Throttle getThrottlePolicy(@Nullable Map<String, ?> serviceConfig) {
        String retryThrottlingKey = "retryThrottling";
        if (serviceConfig == null || !serviceConfig.containsKey(retryThrottlingKey)) {
            return null;
        }
        Map<String, ?> throttling = ServiceConfigUtil.getObject(serviceConfig, retryThrottlingKey);
        float maxTokens = ServiceConfigUtil.getDouble(throttling, "maxTokens").floatValue();
        float tokenRatio = ServiceConfigUtil.getDouble(throttling, "tokenRatio").floatValue();
        Preconditions.checkState(maxTokens > 0.0f, "maxToken should be greater than zero");
        Preconditions.checkState(tokenRatio > 0.0f, "tokenRatio should be greater than zero");
        return new RetriableStream.Throttle(maxTokens, tokenRatio);
    }

    @Nullable
    static Integer getMaxAttemptsFromRetryPolicy(Map<String, ?> retryPolicy) {
        if (!retryPolicy.containsKey("maxAttempts")) {
            return null;
        }
        return ServiceConfigUtil.getDouble(retryPolicy, "maxAttempts").intValue();
    }

    @Nullable
    static Long getInitialBackoffNanosFromRetryPolicy(Map<String, ?> retryPolicy) {
        if (!retryPolicy.containsKey(RETRY_POLICY_INITIAL_BACKOFF_KEY)) {
            return null;
        }
        String rawInitialBackoff = ServiceConfigUtil.getString(retryPolicy, RETRY_POLICY_INITIAL_BACKOFF_KEY);
        try {
            return ServiceConfigUtil.parseDuration(rawInitialBackoff);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    static Long getMaxBackoffNanosFromRetryPolicy(Map<String, ?> retryPolicy) {
        if (!retryPolicy.containsKey(RETRY_POLICY_MAX_BACKOFF_KEY)) {
            return null;
        }
        String rawMaxBackoff = ServiceConfigUtil.getString(retryPolicy, RETRY_POLICY_MAX_BACKOFF_KEY);
        try {
            return ServiceConfigUtil.parseDuration(rawMaxBackoff);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    static Double getBackoffMultiplierFromRetryPolicy(Map<String, ?> retryPolicy) {
        if (!retryPolicy.containsKey(RETRY_POLICY_BACKOFF_MULTIPLIER_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getDouble(retryPolicy, RETRY_POLICY_BACKOFF_MULTIPLIER_KEY);
    }

    private static Set<Status.Code> getStatusCodesFromList(List<?> statuses) {
        EnumSet<Status.Code> codes = EnumSet.noneOf(Status.Code.class);
        for (Object status : statuses) {
            Status.Code code;
            if (status instanceof Double) {
                Double statusD = (Double)status;
                int codeValue = statusD.intValue();
                Verify.verify((double)codeValue == statusD, "Status code %s is not integral", status);
                code = Status.fromCodeValue(codeValue).getCode();
                Verify.verify(code.value() == statusD.intValue(), "Status code %s is not valid", status);
            } else if (status instanceof String) {
                try {
                    code = Status.Code.valueOf((String)status);
                }
                catch (IllegalArgumentException iae) {
                    throw new VerifyException("Status code " + status + " is not valid", iae);
                }
            } else {
                throw new VerifyException("Can not convert status code " + status + " to Status.Code, because its type is " + status.getClass());
            }
            codes.add(code);
        }
        return Collections.unmodifiableSet(codes);
    }

    static Set<Status.Code> getRetryableStatusCodesFromRetryPolicy(Map<String, ?> retryPolicy) {
        Verify.verify(retryPolicy.containsKey(RETRY_POLICY_RETRYABLE_STATUS_CODES_KEY), "%s is required in retry policy", (Object)RETRY_POLICY_RETRYABLE_STATUS_CODES_KEY);
        Set<Status.Code> codes = ServiceConfigUtil.getStatusCodesFromList(ServiceConfigUtil.getList(retryPolicy, RETRY_POLICY_RETRYABLE_STATUS_CODES_KEY));
        Verify.verify(!codes.isEmpty(), "%s must not be empty", (Object)RETRY_POLICY_RETRYABLE_STATUS_CODES_KEY);
        Verify.verify(!codes.contains((Object)Status.Code.OK), "%s must not contain OK", (Object)RETRY_POLICY_RETRYABLE_STATUS_CODES_KEY);
        return codes;
    }

    @Nullable
    static Integer getMaxAttemptsFromHedgingPolicy(Map<String, ?> hedgingPolicy) {
        if (!hedgingPolicy.containsKey("maxAttempts")) {
            return null;
        }
        return ServiceConfigUtil.getDouble(hedgingPolicy, "maxAttempts").intValue();
    }

    @Nullable
    static Long getHedgingDelayNanosFromHedgingPolicy(Map<String, ?> hedgingPolicy) {
        if (!hedgingPolicy.containsKey(HEDGING_POLICY_HEDGING_DELAY_KEY)) {
            return null;
        }
        String rawHedgingDelay = ServiceConfigUtil.getString(hedgingPolicy, HEDGING_POLICY_HEDGING_DELAY_KEY);
        try {
            return ServiceConfigUtil.parseDuration(rawHedgingDelay);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static Set<Status.Code> getNonFatalStatusCodesFromHedgingPolicy(Map<String, ?> hedgingPolicy) {
        if (!hedgingPolicy.containsKey(HEDGING_POLICY_NON_FATAL_STATUS_CODES_KEY)) {
            return Collections.unmodifiableSet(EnumSet.noneOf(Status.Code.class));
        }
        Set<Status.Code> codes = ServiceConfigUtil.getStatusCodesFromList(ServiceConfigUtil.getList(hedgingPolicy, HEDGING_POLICY_NON_FATAL_STATUS_CODES_KEY));
        Verify.verify(!codes.contains((Object)Status.Code.OK), "%s must not contain OK", (Object)HEDGING_POLICY_NON_FATAL_STATUS_CODES_KEY);
        return codes;
    }

    @Nullable
    static String getServiceFromName(Map<String, ?> name) {
        if (!name.containsKey(NAME_SERVICE_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getString(name, NAME_SERVICE_KEY);
    }

    @Nullable
    static String getMethodFromName(Map<String, ?> name) {
        if (!name.containsKey(NAME_METHOD_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getString(name, NAME_METHOD_KEY);
    }

    @Nullable
    static Map<String, ?> getRetryPolicyFromMethodConfig(Map<String, ?> methodConfig) {
        if (!methodConfig.containsKey(METHOD_CONFIG_RETRY_POLICY_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getObject(methodConfig, METHOD_CONFIG_RETRY_POLICY_KEY);
    }

    @Nullable
    static Map<String, ?> getHedgingPolicyFromMethodConfig(Map<String, ?> methodConfig) {
        if (!methodConfig.containsKey(METHOD_CONFIG_HEDGING_POLICY_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getObject(methodConfig, METHOD_CONFIG_HEDGING_POLICY_KEY);
    }

    @Nullable
    static List<Map<String, ?>> getNameListFromMethodConfig(Map<String, ?> methodConfig) {
        if (!methodConfig.containsKey(METHOD_CONFIG_NAME_KEY)) {
            return null;
        }
        return ServiceConfigUtil.checkObjectList(ServiceConfigUtil.getList(methodConfig, METHOD_CONFIG_NAME_KEY));
    }

    @Nullable
    static Long getTimeoutFromMethodConfig(Map<String, ?> methodConfig) {
        if (!methodConfig.containsKey(METHOD_CONFIG_TIMEOUT_KEY)) {
            return null;
        }
        String rawTimeout = ServiceConfigUtil.getString(methodConfig, METHOD_CONFIG_TIMEOUT_KEY);
        try {
            return ServiceConfigUtil.parseDuration(rawTimeout);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    static Boolean getWaitForReadyFromMethodConfig(Map<String, ?> methodConfig) {
        if (!methodConfig.containsKey(METHOD_CONFIG_WAIT_FOR_READY_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getBoolean(methodConfig, METHOD_CONFIG_WAIT_FOR_READY_KEY);
    }

    @Nullable
    static Integer getMaxRequestMessageBytesFromMethodConfig(Map<String, ?> methodConfig) {
        if (!methodConfig.containsKey(METHOD_CONFIG_MAX_REQUEST_MESSAGE_BYTES_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getDouble(methodConfig, METHOD_CONFIG_MAX_REQUEST_MESSAGE_BYTES_KEY).intValue();
    }

    @Nullable
    static Integer getMaxResponseMessageBytesFromMethodConfig(Map<String, ?> methodConfig) {
        if (!methodConfig.containsKey(METHOD_CONFIG_MAX_RESPONSE_MESSAGE_BYTES_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getDouble(methodConfig, METHOD_CONFIG_MAX_RESPONSE_MESSAGE_BYTES_KEY).intValue();
    }

    @Nullable
    static List<Map<String, ?>> getMethodConfigFromServiceConfig(Map<String, ?> serviceConfig) {
        if (!serviceConfig.containsKey(SERVICE_CONFIG_METHOD_CONFIG_KEY)) {
            return null;
        }
        return ServiceConfigUtil.checkObjectList(ServiceConfigUtil.getList(serviceConfig, SERVICE_CONFIG_METHOD_CONFIG_KEY));
    }

    @VisibleForTesting
    public static List<Map<String, ?>> getLoadBalancingConfigsFromServiceConfig(Map<String, ?> serviceConfig) {
        ArrayList lbConfigs = new ArrayList();
        if (serviceConfig.containsKey(SERVICE_CONFIG_LOAD_BALANCING_CONFIG_KEY)) {
            List<?> configs = ServiceConfigUtil.getList(serviceConfig, SERVICE_CONFIG_LOAD_BALANCING_CONFIG_KEY);
            for (Map<String, ?> config : ServiceConfigUtil.checkObjectList(configs)) {
                lbConfigs.add(config);
            }
        }
        if (lbConfigs.isEmpty() && serviceConfig.containsKey(SERVICE_CONFIG_LOAD_BALANCING_POLICY_KEY)) {
            String policy = ServiceConfigUtil.getString(serviceConfig, SERVICE_CONFIG_LOAD_BALANCING_POLICY_KEY);
            policy = policy.toLowerCase(Locale.ROOT);
            Map fakeConfig = Collections.singletonMap(policy, Collections.emptyMap());
            lbConfigs.add(fakeConfig);
        }
        return Collections.unmodifiableList(lbConfigs);
    }

    public static LbConfig unwrapLoadBalancingConfig(Map<String, ?> lbConfig) {
        if (lbConfig.size() != 1) {
            throw new RuntimeException("There are " + lbConfig.size() + " fields in a LoadBalancingConfig object. Exactly one is expected. Config=" + lbConfig);
        }
        String key = lbConfig.entrySet().iterator().next().getKey();
        return new LbConfig(key, ServiceConfigUtil.getObject(lbConfig, key));
    }

    public static List<LbConfig> unwrapLoadBalancingConfigList(List<Map<String, ?>> list) {
        ArrayList<LbConfig> result = new ArrayList<LbConfig>();
        for (Map<String, ?> rawChildPolicy : list) {
            result.add(ServiceConfigUtil.unwrapLoadBalancingConfig(rawChildPolicy));
        }
        return Collections.unmodifiableList(result);
    }

    public static String getBalancerNameFromXdsConfig(Map<String, ?> rawXdsConfig) {
        return ServiceConfigUtil.getString(rawXdsConfig, XDS_CONFIG_BALANCER_NAME_KEY);
    }

    @Nullable
    public static List<LbConfig> getChildPolicyFromXdsConfig(Map<String, ?> rawXdsConfig) {
        List<?> rawChildPolicies = ServiceConfigUtil.getList(rawXdsConfig, XDS_CONFIG_CHILD_POLICY_KEY);
        if (rawChildPolicies != null) {
            return ServiceConfigUtil.unwrapLoadBalancingConfigList(ServiceConfigUtil.checkObjectList(rawChildPolicies));
        }
        return null;
    }

    @Nullable
    public static List<LbConfig> getFallbackPolicyFromXdsConfig(Map<String, ?> rawXdsConfig) {
        List<?> rawFallbackPolicies = ServiceConfigUtil.getList(rawXdsConfig, XDS_CONFIG_FALLBACK_POLICY_KEY);
        if (rawFallbackPolicies != null) {
            return ServiceConfigUtil.unwrapLoadBalancingConfigList(ServiceConfigUtil.checkObjectList(rawFallbackPolicies));
        }
        return null;
    }

    @Nullable
    public static String getStickinessMetadataKeyFromServiceConfig(Map<String, ?> serviceConfig) {
        if (!serviceConfig.containsKey(SERVICE_CONFIG_STICKINESS_METADATA_KEY)) {
            return null;
        }
        return ServiceConfigUtil.getString(serviceConfig, SERVICE_CONFIG_STICKINESS_METADATA_KEY);
    }

    @Nullable
    static List<?> getList(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof List)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not List", value, key, obj));
        }
        return (List)value;
    }

    @Nullable
    static Map<String, ?> getObject(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof Map)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not object", value, key, obj));
        }
        return (Map)value;
    }

    @Nullable
    static Double getDouble(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof Double)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not Double", value, key, obj));
        }
        return (Double)value;
    }

    @Nullable
    static String getString(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof String)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not String", value, key, obj));
        }
        return (String)value;
    }

    @Nullable
    static Boolean getBoolean(Map<String, ?> obj, String key) {
        assert (key != null);
        if (!obj.containsKey(key)) {
            return null;
        }
        Object value = obj.get(key);
        if (!(value instanceof Boolean)) {
            throw new ClassCastException(String.format("value '%s' for key '%s' in '%s' is not Boolean", value, key, obj));
        }
        return (Boolean)value;
    }

    static List<Map<String, ?>> checkObjectList(List<?> rawList) {
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof Map) continue;
            throw new ClassCastException(String.format("value %s for idx %d in %s is not object", rawList.get(i), i, rawList));
        }
        return rawList;
    }

    static List<String> checkStringList(List<?> rawList) {
        for (int i = 0; i < rawList.size(); ++i) {
            if (rawList.get(i) instanceof String) continue;
            throw new ClassCastException(String.format("value '%s' for idx %d in '%s' is not string", rawList.get(i), i, rawList));
        }
        return rawList;
    }

    private static long parseDuration(String value) throws ParseException {
        int nanos;
        if (value.isEmpty() || value.charAt(value.length() - 1) != 's') {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        boolean negative = false;
        if (value.charAt(0) == '-') {
            negative = true;
            value = value.substring(1);
        }
        String secondValue = value.substring(0, value.length() - 1);
        String nanoValue = "";
        int pointPosition = secondValue.indexOf(46);
        if (pointPosition != -1) {
            nanoValue = secondValue.substring(pointPosition + 1);
            secondValue = secondValue.substring(0, pointPosition);
        }
        long seconds = Long.parseLong(secondValue);
        int n = nanos = nanoValue.isEmpty() ? 0 : ServiceConfigUtil.parseNanos(nanoValue);
        if (seconds < 0L) {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        if (negative) {
            seconds = -seconds;
            nanos = -nanos;
        }
        try {
            return ServiceConfigUtil.normalizedDuration(seconds, nanos);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Duration value is out of range.", 0);
        }
    }

    private static int parseNanos(String value) throws ParseException {
        int result = 0;
        for (int i = 0; i < 9; ++i) {
            result *= 10;
            if (i >= value.length()) continue;
            if (value.charAt(i) < '0' || value.charAt(i) > '9') {
                throw new ParseException("Invalid nanoseconds.", 0);
            }
            result += value.charAt(i) - 48;
        }
        return result;
    }

    private static long normalizedDuration(long seconds, int nanos) {
        if ((long)nanos <= -NANOS_PER_SECOND || (long)nanos >= NANOS_PER_SECOND) {
            seconds = LongMath.checkedAdd(seconds, (long)nanos / NANOS_PER_SECOND);
            nanos = (int)((long)nanos % NANOS_PER_SECOND);
        }
        if (seconds > 0L && nanos < 0) {
            nanos = (int)((long)nanos + NANOS_PER_SECOND);
            --seconds;
        }
        if (seconds < 0L && nanos > 0) {
            nanos = (int)((long)nanos - NANOS_PER_SECOND);
            ++seconds;
        }
        if (!ServiceConfigUtil.durationIsValid(seconds, nanos)) {
            throw new IllegalArgumentException(String.format("Duration is not valid. See proto definition for valid values. Seconds (%s) must be in range [-315,576,000,000, +315,576,000,000]. Nanos (%s) must be in range [-999,999,999, +999,999,999]. Nanos must have the same sign as seconds", seconds, nanos));
        }
        return ServiceConfigUtil.saturatedAdd(TimeUnit.SECONDS.toNanos(seconds), nanos);
    }

    private static boolean durationIsValid(long seconds, int nanos) {
        if (seconds < -315576000000L || seconds > 315576000000L) {
            return false;
        }
        if ((long)nanos < -999999999L || (long)nanos >= NANOS_PER_SECOND) {
            return false;
        }
        return seconds >= 0L && nanos >= 0 || seconds <= 0L && nanos <= 0;
    }

    private static long saturatedAdd(long a, long b) {
        long naiveSum;
        if ((a ^ b) < 0L | (a ^ (naiveSum = a + b)) >= 0L) {
            return naiveSum;
        }
        return Long.MAX_VALUE + (naiveSum >>> 63 ^ 1L);
    }

    public static final class LbConfig {
        private final String policyName;
        private final Map<String, ?> rawConfigValue;

        public LbConfig(String policyName, Map<String, ?> rawConfigValue) {
            this.policyName = Preconditions.checkNotNull(policyName, "policyName");
            this.rawConfigValue = Preconditions.checkNotNull(rawConfigValue, "rawConfigValue");
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public Map<String, ?> getRawConfigValue() {
            return this.rawConfigValue;
        }

        public boolean equals(Object o) {
            if (o instanceof LbConfig) {
                LbConfig other = (LbConfig)o;
                return this.policyName.equals(other.policyName) && this.rawConfigValue.equals(other.rawConfigValue);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.policyName, this.rawConfigValue);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("policyName", this.policyName).add("rawConfigValue", this.rawConfigValue).toString();
        }
    }
}

