/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.AbstractPdfFormField;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.pdf.IPdfPageFormCopier;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfPageFormCopier
implements IPdfPageFormCopier {
    private PdfAcroForm formFrom;
    private PdfAcroForm formTo;
    private PdfDocument documentFrom;
    private PdfDocument documentTo;
    private final Set<PdfObject> collectedFieldObjects = new LinkedHashSet<PdfObject>();
    private static Logger logger = LoggerFactory.getLogger(PdfPageFormCopier.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(PdfPage fromPage, PdfPage toPage) {
        if (this.documentFrom != fromPage.getDocument()) {
            this.documentFrom = fromPage.getDocument();
            this.formFrom = PdfFormCreator.getAcroForm(this.documentFrom, false);
        }
        if (this.documentTo != toPage.getDocument()) {
            this.documentTo = toPage.getDocument();
        }
        this.formTo = PdfFormCreator.getAcroForm(this.documentTo, true);
        if (this.formFrom == null) {
            return;
        }
        ArrayList<PdfName> excludedKeys = new ArrayList<PdfName>();
        excludedKeys.add(PdfName.Fields);
        excludedKeys.add(PdfName.DR);
        PdfDictionary dict = ((PdfDictionary)this.formFrom.getPdfObject()).copyTo(this.documentTo, excludedKeys, false);
        ((PdfDictionary)this.formTo.getPdfObject()).mergeDifferent(dict);
        Map<String, PdfFormField> fieldsFrom = this.formFrom.getAllFormFields();
        if (fieldsFrom.size() <= 0) {
            return;
        }
        Map<String, PdfFormField> fieldsTo = this.formTo.getRootFormFields();
        List annots = toPage.getAnnotations();
        try {
            for (PdfAnnotation annot : annots) {
                if (!annot.getSubtype().equals((Object)PdfName.Widget)) continue;
                this.copyField(fieldsFrom, fieldsTo, annot);
            }
            PdfArray fieldsArray = this.formTo.getFields();
            fieldsArray.addAll(this.collectedFieldObjects);
            fieldsArray.setModified();
            if (!this.documentFrom.isTagged() || !this.documentTo.isTagged()) {
                PdfFormCreator.getAcroForm(this.documentTo, true);
            }
        }
        finally {
            this.collectedFieldObjects.clear();
        }
    }

    public void recreateAcroformToProcessCopiedFields(PdfDocument documentTo) {
        PdfFormCreator.getAcroForm(documentTo, true);
    }

    private AbstractPdfFormField makeFormField(PdfObject fieldDict) {
        AbstractPdfFormField field = PdfFormField.makeFormFieldOrAnnotation(fieldDict, this.documentTo);
        if (field == null) {
            logger.warn(MessageFormatUtil.format((String)"Cannot create form field from a given PDF object: {0}", (Object[])new Object[]{fieldDict.getIndirectReference()}));
        }
        return field;
    }

    private void copyField(Map<String, PdfFormField> fieldsFrom, Map<String, PdfFormField> fieldsTo, PdfAnnotation currentAnnot) {
        PdfDictionary parent = ((PdfDictionary)currentAnnot.getPdfObject()).getAsDictionary(PdfName.Parent);
        if (parent != null) {
            PdfFormField parentField = PdfPageFormCopier.getParentField(parent, this.documentTo);
            if (parentField == null) {
                return;
            }
            PdfString parentName = parentField.getFieldName();
            if (parentName == null) {
                return;
            }
            this.copyParentFormField(fieldsTo, currentAnnot, parentField);
        } else {
            PdfString annotName = ((PdfDictionary)currentAnnot.getPdfObject()).getAsString(PdfName.T);
            String annotNameString = null;
            if (annotName != null) {
                annotNameString = annotName.toUnicodeString();
            }
            if (annotNameString != null && fieldsFrom.containsKey(annotNameString)) {
                PdfFormField field = (PdfFormField)this.makeFormField(currentAnnot.getPdfObject());
                if (field == null) {
                    return;
                }
                if (!this.collectedFieldObjects.contains(field.getPdfObject())) {
                    if (fieldsTo.get(annotNameString) != null) {
                        logger.warn(MessageFormatUtil.format((String)"The document already has field {0}. Annotations of the fields with this name will be added to the existing one as children. If you want to have separate fields, please, rename them manually before copying.", (Object[])new Object[]{annotNameString}));
                    }
                    this.collectedFieldObjects.add((PdfObject)field.getPdfObject());
                }
                field.updateDefaultAppearance();
            }
        }
    }

    private void copyParentFormField(Map<String, PdfFormField> fieldsTo, PdfAnnotation annot, PdfFormField parentField) {
        String parentName = parentField.getFieldName().toUnicodeString();
        PdfFormField existingField = fieldsTo.get(parentName);
        PdfFormField field = this.createParentFieldCopy((PdfDictionary)annot.getPdfObject(), this.documentTo);
        if (!this.collectedFieldObjects.contains(field.getPdfObject())) {
            if (existingField != null) {
                logger.warn(MessageFormatUtil.format((String)"The document already has field {0}. Annotations of the fields with this name will be added to the existing one as children. If you want to have separate fields, please, rename them manually before copying.", (Object[])new Object[]{parentName}));
            }
            this.collectedFieldObjects.add((PdfObject)field.getPdfObject());
        }
    }

    private static PdfFormField getParentField(PdfDictionary parent, PdfDocument pdfDoc) {
        PdfDictionary parentOfParent = parent.getAsDictionary(PdfName.Parent);
        if (parentOfParent != null) {
            return PdfPageFormCopier.getParentField(parentOfParent, pdfDoc);
        }
        return PdfFormField.makeFormField((PdfObject)parent, pdfDoc);
    }

    private PdfFormField createParentFieldCopy(PdfDictionary fieldDict, PdfDocument pdfDoc) {
        PdfFormField field;
        PdfDictionary parent = fieldDict.getAsDictionary(PdfName.Parent);
        if (parent != null) {
            PdfArray kids = (PdfArray)parent.get(PdfName.Kids);
            if (kids == null) {
                parent.put(PdfName.Kids, (PdfObject)new PdfArray((PdfObject)fieldDict));
            } else if (!kids.contains((PdfObject)fieldDict)) {
                kids.add((PdfObject)fieldDict);
            }
            field = this.createParentFieldCopy(parent, pdfDoc);
        } else {
            field = PdfFormField.makeFormField((PdfObject)fieldDict, pdfDoc);
        }
        return field;
    }
}

