/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormAnnotation;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.RadioFormFieldBuilder;
import com.itextpdf.forms.form.element.Radio;
import com.itextpdf.forms.form.renderer.AbstractFormFieldRenderer;
import com.itextpdf.forms.util.BorderStyleUtil;
import com.itextpdf.forms.util.DrawingUtil;
import com.itextpdf.forms.util.FormFieldRendererUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.BorderRadius;
import com.itextpdf.layout.properties.HorizontalAlignment;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.Map;

public class RadioRenderer
extends AbstractFormFieldRenderer {
    private static final Color DEFAULT_CHECKED_COLOR = ColorConstants.BLACK;
    private static final float DEFAULT_SIZE = 8.25f;
    private static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGNMENT = HorizontalAlignment.CENTER;
    private static final VerticalAlignment DEFAULT_VERTICAL_ALIGNMENT = VerticalAlignment.MIDDLE;

    public RadioRenderer(Radio modelElement) {
        super(modelElement);
        this.setProperty(75, VerticalAlignment.MIDDLE);
    }

    public IRenderer getNextRenderer() {
        return new RadioRenderer((Radio)this.modelElement);
    }

    public void drawBorder(DrawContext drawContext) {
    }

    public void drawBackground(DrawContext drawContext) {
    }

    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        return rect;
    }

    @Override
    protected IRenderer createFlatRenderer() {
        UnitValue heightUV = this.getPropertyAsUnitValue(27);
        UnitValue widthUV = this.getPropertyAsUnitValue(77);
        float height = null == heightUV ? 8.25f : heightUV.getValue();
        float width = null == widthUV ? 8.25f : widthUV.getValue();
        float size = Math.min(height, width);
        this.setProperty(27, UnitValue.createPointValue((float)height));
        this.setProperty(77, UnitValue.createPointValue((float)width));
        Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)((Paragraph)((Paragraph)new Paragraph().setWidth(size)).setHeight(size)).setHorizontalAlignment(DEFAULT_HORIZONTAL_ALIGNMENT)).setVerticalAlignment(DEFAULT_VERTICAL_ALIGNMENT)).setMargin(0.0f);
        paragraph.setProperty(105, this.getProperty(105));
        paragraph.setBorder((Border)this.getProperty(9));
        paragraph.setProperty(6, this.getProperty(6));
        paragraph.setBorderRadius(new BorderRadius(UnitValue.createPercentValue((float)50.0f)));
        return new FlatParagraphRenderer(paragraph);
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
    }

    public boolean isBoxChecked() {
        return Boolean.TRUE.equals(this.getProperty(0x200007));
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        PdfDocument doc = drawContext.getDocument();
        PdfAcroForm form = PdfFormCreator.getAcroForm(doc, true);
        Rectangle area = this.flatRenderer.getOccupiedArea().getBBox().clone();
        Map<Integer, Object> properties = FormFieldRendererUtil.removeProperties(this.modelElement);
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        String groupName = (String)this.getProperty(0x20000C);
        if (groupName == null || groupName.isEmpty()) {
            throw new PdfException("Radio group name cannot be empty.");
        }
        PdfButtonFormField radioGroup = (PdfButtonFormField)form.getField(groupName);
        if (null == radioGroup) {
            radioGroup = ((RadioFormFieldBuilder)new RadioFormFieldBuilder(doc, groupName).setGenericConformanceLevel(this.getGenericConformanceLevel(doc))).createRadioGroup();
            radioGroup.disableFieldRegeneration();
            radioGroup.setValue("Off");
        } else {
            radioGroup.disableFieldRegeneration();
        }
        if (this.isBoxChecked()) {
            radioGroup.setValue(this.getModelId());
        }
        PdfFormAnnotation radio = ((RadioFormFieldBuilder)new RadioFormFieldBuilder(doc, null).setGenericConformanceLevel(this.getGenericConformanceLevel(doc))).createRadioButton(this.getModelId(), area);
        radio.disableFieldRegeneration();
        Background background = (Background)this.getProperty(6);
        if (background != null) {
            radio.setBackgroundColor(background.getColor());
        }
        BorderStyleUtil.applyBorderProperty((IPropertyContainer)this, radio);
        radio.setFormFieldElement((Radio)this.modelElement);
        radioGroup.addKid(radio);
        radioGroup.enableFieldRegeneration();
        this.applyAccessibilityProperties(radioGroup, doc);
        form.addField(radioGroup, page);
        FormFieldRendererUtil.reapplyProperties(this.modelElement, properties);
    }

    @Override
    protected boolean isLayoutBasedOnFlatRenderer() {
        return false;
    }

    private boolean isDrawCircledBorder() {
        return Boolean.TRUE.equals(this.getProperty(0x20000D));
    }

    private class FlatParagraphRenderer
    extends ParagraphRenderer {
        public FlatParagraphRenderer(Paragraph modelElement) {
            super(modelElement);
        }

        public void drawChildren(DrawContext drawContext) {
            if (!RadioRenderer.this.isBoxChecked()) {
                return;
            }
            PdfCanvas canvas = drawContext.getCanvas();
            boolean isTaggingEnabled = drawContext.isTaggingEnabled();
            if (isTaggingEnabled) {
                TagTreePointer tp = drawContext.getDocument().getTagStructureContext().getAutoTaggingPointer();
                canvas.openTag(tp.getTagReference());
            }
            Rectangle rectangle = this.getOccupiedArea().getBBox().clone();
            Border border = (Border)this.getProperty(9);
            if (border != null) {
                rectangle.applyMargins(border.getWidth(), border.getWidth(), border.getWidth(), border.getWidth(), false);
            }
            float radius = Math.min(rectangle.getWidth(), rectangle.getHeight()) / 2.0f;
            canvas.saveState();
            canvas.setFillColor(DEFAULT_CHECKED_COLOR);
            DrawingUtil.drawCircle(canvas, rectangle.getLeft() + radius, rectangle.getBottom() + radius, radius / 2.0f);
            canvas.restoreState();
            if (isTaggingEnabled) {
                canvas.closeTag();
            }
        }

        public void drawBorder(DrawContext drawContext) {
            Border border = this.getBorders()[0];
            if (border == null || !RadioRenderer.this.isDrawCircledBorder()) {
                super.drawBorder(drawContext);
                return;
            }
            float borderWidth = border.getWidth();
            if (borderWidth > 0.0f && border.getColor() != null) {
                Rectangle rectangle = this.getOccupiedArea().getBBox().clone();
                rectangle.applyMargins(borderWidth, borderWidth, borderWidth, borderWidth, false);
                float cx = rectangle.getX() + rectangle.getWidth() / 2.0f;
                float cy = rectangle.getY() + rectangle.getHeight() / 2.0f;
                float r = (Math.min(rectangle.getWidth(), rectangle.getHeight()) + borderWidth) / 2.0f;
                boolean isTaggingEnabled = drawContext.isTaggingEnabled();
                PdfCanvas canvas = drawContext.getCanvas();
                if (isTaggingEnabled) {
                    canvas.openTag((CanvasTag)new CanvasArtifact());
                }
                canvas.setStrokeColor(border.getColor()).setLineWidth(borderWidth).circle((double)cx, (double)cy, (double)r).stroke();
                if (isTaggingEnabled) {
                    canvas.closeTag();
                }
            }
        }

        public void drawBackground(DrawContext drawContext) {
            Color backgroundColor;
            Border border = this.getBorders()[0];
            if (border == null || !RadioRenderer.this.isDrawCircledBorder()) {
                super.drawBackground(drawContext);
                return;
            }
            float borderWidth = border.getWidth();
            Background background = (Background)this.getProperty(6);
            Color color = backgroundColor = background == null ? null : background.getColor();
            if (backgroundColor != null) {
                Rectangle rectangle = this.getOccupiedArea().getBBox().clone();
                rectangle.applyMargins(borderWidth, borderWidth, borderWidth, borderWidth, false);
                float cx = rectangle.getX() + rectangle.getWidth() / 2.0f;
                float cy = rectangle.getY() + rectangle.getHeight() / 2.0f;
                float r = (Math.min(rectangle.getWidth(), rectangle.getHeight()) + borderWidth) / 2.0f;
                boolean isTaggingEnabled = drawContext.isTaggingEnabled();
                PdfCanvas canvas = drawContext.getCanvas();
                if (isTaggingEnabled) {
                    canvas.openTag((CanvasTag)new CanvasArtifact());
                }
                canvas.setFillColor(backgroundColor).circle((double)cx, (double)cy, (double)r).fill();
                if (isTaggingEnabled) {
                    canvas.closeTag();
                }
            }
        }
    }
}

