/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfa;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.xfa.AcroFieldsSearch;
import com.itextpdf.forms.xfa.Xml2Som;
import com.itextpdf.forms.xfa.Xml2SomDatasets;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.VersionConforming;
import com.itextpdf.kernel.utils.XmlProcessorCreator;
import com.itextpdf.kernel.xmp.XmlDomWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XfaForm {
    private static final int INIT_SERIALIZER_BUFFER_SIZE = 16384;
    private Node templateNode;
    private Xml2SomDatasets datasetsSom;
    private Node datasetsNode;
    private AcroFieldsSearch acroFieldsSom;
    private boolean xfaPresent = false;
    private Document domDocument;
    public static final String XFA_DATA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";

    public XfaForm() {
        this(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><xdp:xdp xmlns:xdp=\"http://ns.adobe.com/xdp/\"><template xmlns=\"http://www.xfa.org/schema/xfa-template/3.3/\"></template><xfa:datasets xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\"><xfa:data></xfa:data></xfa:datasets></xdp:xdp>".getBytes(StandardCharsets.UTF_8)));
    }

    public XfaForm(InputStream inputStream) {
        try {
            this.initXfaForm(inputStream);
        }
        catch (Exception e) {
            throw new PdfException(e.getMessage(), (Throwable)e);
        }
    }

    public XfaForm(Document domDocument) {
        this.setDomDocument(domDocument);
    }

    public XfaForm(PdfDictionary acroFormDictionary) {
        PdfObject xfa = acroFormDictionary.get(PdfName.XFA);
        if (xfa != null) {
            try {
                this.initXfaForm(xfa);
            }
            catch (Exception e) {
                throw new PdfException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public XfaForm(PdfDocument pdfDocument) {
        PdfObject xfa = XfaForm.getXfaObject(pdfDocument);
        if (xfa != null) {
            try {
                this.initXfaForm(xfa);
            }
            catch (Exception e) {
                throw new PdfException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void setXfaForm(XfaForm form, PdfDocument pdfDocument) throws IOException {
        PdfAcroForm acroForm = PdfFormCreator.getAcroForm(pdfDocument, true);
        XfaForm.setXfaForm(form, acroForm);
    }

    public static void setXfaForm(XfaForm form, PdfAcroForm acroForm) throws IOException {
        if (form == null || acroForm == null || acroForm.getPdfDocument() == null) {
            throw new IllegalArgumentException("XfaForm, PdfAcroForm and PdfAcroForm's document shall not be null");
        }
        PdfDocument document = acroForm.getPdfDocument();
        if (VersionConforming.validatePdfVersionForDeprecatedFeatureLogError((PdfDocument)document, (PdfVersion)PdfVersion.PDF_2_0, (String)"XFA is deprecated in PDF 2.0. The XFA form will not be written to the document")) {
            return;
        }
        PdfObject xfa = XfaForm.getXfaObject(acroForm);
        if (xfa != null && xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            int t = -1;
            int d = -1;
            for (int k = 0; k < ar.size(); k += 2) {
                PdfString s = ar.getAsString(k);
                if ("template".equals(s.toString())) {
                    t = k + 1;
                }
                if (!"datasets".equals(s.toString())) continue;
                d = k + 1;
            }
            if (t > -1 && d > -1) {
                PdfStream tStream = new PdfStream(XfaForm.serializeDocument(form.templateNode));
                tStream.setCompressionLevel(document.getWriter().getCompressionLevel());
                ar.set(t, (PdfObject)tStream);
                PdfStream dStream = new PdfStream(XfaForm.serializeDocument(form.datasetsNode));
                dStream.setCompressionLevel(document.getWriter().getCompressionLevel());
                ar.set(d, (PdfObject)dStream);
                ar.setModified();
                ar.flush();
                acroForm.put(PdfName.XFA, (PdfObject)new PdfArray(ar));
                acroForm.setModified();
                if (!((PdfDictionary)acroForm.getPdfObject()).isIndirect()) {
                    document.getCatalog().setModified();
                }
                return;
            }
        }
        PdfStream stream = new PdfStream(XfaForm.serializeDocument(form.domDocument));
        stream.setCompressionLevel(document.getWriter().getCompressionLevel());
        stream.flush();
        acroForm.put(PdfName.XFA, (PdfObject)stream);
        acroForm.setModified();
        if (!((PdfDictionary)acroForm.getPdfObject()).isIndirect()) {
            document.getCatalog().setModified();
        }
    }

    public static Map<String, Node> extractXFANodes(Document domDocument) {
        HashMap<String, Node> xfaNodes = new HashMap<String, Node>();
        Node n = domDocument.getFirstChild();
        while (n.getChildNodes().getLength() == 0) {
            n = n.getNextSibling();
        }
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            String s = n.getLocalName();
            xfaNodes.put(s, n);
        }
        return xfaNodes;
    }

    public void write(PdfDocument document) throws IOException {
        XfaForm.setXfaForm(this, document);
    }

    public void write(PdfAcroForm acroForm) throws IOException {
        XfaForm.setXfaForm(this, acroForm);
    }

    public void setXfaFieldValue(String name, String value) {
        if (this.isXfaPresent() && (name = this.findFieldName(name)) != null) {
            String shortName = Xml2Som.getShortName(name);
            Node xn = this.findDatasetsNode(shortName);
            if (xn == null) {
                xn = this.datasetsSom.insertNode(this.getDatasetsNode(), shortName);
            }
            this.setNodeText(xn, value);
        }
    }

    public String getXfaFieldValue(String name) {
        if (this.isXfaPresent() && (name = this.findFieldName(name)) != null) {
            name = Xml2Som.getShortName(name);
            return XfaForm.getNodeText(this.findDatasetsNode(name));
        }
        return null;
    }

    public boolean isXfaPresent() {
        return this.xfaPresent;
    }

    public String findFieldName(String name) {
        if (this.acroFieldsSom == null && this.xfaPresent && this.datasetsSom != null) {
            this.acroFieldsSom = new AcroFieldsSearch(this.datasetsSom.getName2Node().keySet());
        }
        if (this.acroFieldsSom != null && this.xfaPresent) {
            return this.acroFieldsSom.getAcroShort2LongName().containsKey(name) ? this.acroFieldsSom.getAcroShort2LongName().get(name) : this.acroFieldsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
        }
        return null;
    }

    public String findDatasetsName(String name) {
        return this.datasetsSom.getName2Node().containsKey(name) ? name : this.datasetsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public Node findDatasetsNode(String name) {
        if (name == null) {
            return null;
        }
        if ((name = this.findDatasetsName(name)) == null) {
            return null;
        }
        return this.datasetsSom.getName2Node().get(name);
    }

    public static String getNodeText(Node n) {
        return n == null ? "" : XfaForm.getNodeText(n, "");
    }

    public String getNodeTextByPath(String path) {
        if (!this.xfaPresent) {
            return null;
        }
        Xml2SomDatasets nodeSom = new Xml2SomDatasets(this.domDocument);
        AcroFieldsSearch nodeFieldsSom = new AcroFieldsSearch(nodeSom.getName2Node().keySet());
        String foundPath = nodeFieldsSom.inverseSearchGlobal(Xml2Som.splitParts(path));
        if (foundPath != null) {
            Node resultNode = nodeSom.getName2Node().get(foundPath);
            return XfaForm.getNodeText(resultNode);
        }
        return null;
    }

    public void setNodeText(Node n, String text) {
        if (n == null) {
            return;
        }
        Node nc = null;
        while ((nc = n.getFirstChild()) != null) {
            n.removeChild(nc);
        }
        if (n.getAttributes().getNamedItemNS(XFA_DATA_SCHEMA, "dataNode") != null) {
            n.getAttributes().removeNamedItemNS(XFA_DATA_SCHEMA, "dataNode");
        }
        n.appendChild(this.domDocument.createTextNode(text));
    }

    public Document getDomDocument() {
        return this.domDocument;
    }

    public void setDomDocument(Document domDocument) {
        this.domDocument = domDocument;
        this.extractNodes();
    }

    public Node getDatasetsNode() {
        return this.datasetsNode;
    }

    public void fillXfaForm(File file) throws IOException {
        this.fillXfaForm(file, false);
    }

    public void fillXfaForm(File file, boolean readOnly) throws IOException {
        this.fillXfaForm(new FileInputStream(file), readOnly);
    }

    public void fillXfaForm(InputStream is) throws IOException {
        this.fillXfaForm(is, false);
    }

    public void fillXfaForm(InputStream is, boolean readOnly) throws IOException {
        this.fillXfaForm(new InputSource(is), readOnly);
    }

    public void fillXfaForm(InputSource is) throws IOException {
        this.fillXfaForm(is, false);
    }

    public void fillXfaForm(InputSource is, boolean readOnly) throws IOException {
        try {
            DocumentBuilder db = XmlProcessorCreator.createSafeDocumentBuilder((boolean)false, (boolean)false);
            Document newdoc = db.parse(is);
            this.fillXfaForm(newdoc.getDocumentElement(), readOnly);
        }
        catch (SAXException e) {
            throw new PdfException(e.getMessage(), (Throwable)e);
        }
    }

    public void fillXfaForm(Node node) {
        this.fillXfaForm(node, false);
    }

    public void fillXfaForm(Node node, boolean readOnly) {
        NodeList list;
        if (readOnly) {
            NodeList nodeList = this.domDocument.getElementsByTagName("field");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ((Element)nodeList.item(i)).setAttribute("access", "readOnly");
            }
        }
        NodeList allChilds = this.datasetsNode.getChildNodes();
        int len = allChilds.getLength();
        Node data = null;
        for (int k = 0; k < len; ++k) {
            Node n = allChilds.item(k);
            if (n.getNodeType() != 1 || !n.getLocalName().equals("data") || !XFA_DATA_SCHEMA.equals(n.getNamespaceURI())) continue;
            data = n;
            break;
        }
        if (data == null) {
            data = this.datasetsNode.getOwnerDocument().createElementNS(XFA_DATA_SCHEMA, "xfa:data");
            this.datasetsNode.appendChild(data);
        }
        if ((list = data.getChildNodes()).getLength() == 0) {
            data.appendChild(this.domDocument.importNode(node, true));
        } else {
            Node firstNode = this.getFirstElementNode(data);
            if (firstNode != null) {
                data.replaceChild(this.domDocument.importNode(node, true), firstNode);
            }
        }
        this.extractNodes();
    }

    private static String getNodeText(Node n, String name) {
        for (Node n2 = n.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() == 1) {
                name = XfaForm.getNodeText(n2, name);
                continue;
            }
            if (n2.getNodeType() != 3) continue;
            name = name + n2.getNodeValue();
        }
        return name;
    }

    private static PdfObject getXfaObject(PdfDocument pdfDocument) {
        PdfDictionary af = ((PdfDictionary)pdfDocument.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm);
        return af == null ? null : af.get(PdfName.XFA);
    }

    private static PdfObject getXfaObject(PdfAcroForm acroForm) {
        return acroForm == null || acroForm.getPdfObject() == null ? null : ((PdfDictionary)acroForm.getPdfObject()).get(PdfName.XFA);
    }

    private static byte[] serializeDocument(Node n) throws IOException {
        XmlDomWriter xw = new XmlDomWriter(false);
        ByteArrayOutputStream fout = new ByteArrayOutputStream(16384);
        xw.setOutput((OutputStream)fout, null);
        xw.write(n);
        fout.close();
        return fout.toByteArray();
    }

    private void initXfaForm(PdfObject xfa) throws IOException, ParserConfigurationException, SAXException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            for (int k = 1; k < ar.size(); k += 2) {
                PdfObject ob = ar.get(k);
                if (!(ob instanceof PdfStream)) continue;
                byte[] b = ((PdfStream)ob).getBytes();
                bout.write(b);
            }
        } else if (xfa instanceof PdfStream) {
            byte[] b = ((PdfStream)xfa).getBytes();
            bout.write(b);
        }
        bout.close();
        this.initXfaForm(new ByteArrayInputStream(bout.toByteArray()));
    }

    private void initXfaForm(InputStream inputStream) throws IOException, SAXException {
        DocumentBuilder db = XmlProcessorCreator.createSafeDocumentBuilder((boolean)true, (boolean)false);
        this.setDomDocument(db.parse(inputStream));
        this.xfaPresent = true;
    }

    private void extractNodes() {
        Map<String, Node> xfaNodes = XfaForm.extractXFANodes(this.domDocument);
        if (xfaNodes.containsKey("template")) {
            this.templateNode = xfaNodes.get("template");
        }
        if (xfaNodes.containsKey("datasets")) {
            this.datasetsNode = xfaNodes.get("datasets");
            Node dataNode = this.findDataNode(this.datasetsNode);
            this.datasetsSom = new Xml2SomDatasets(dataNode != null ? dataNode : this.datasetsNode.getFirstChild());
        }
        if (this.datasetsNode == null) {
            this.createDatasetsNode(this.domDocument.getFirstChild());
        }
    }

    private void createDatasetsNode(Node n) {
        while (n != null && n.getChildNodes().getLength() == 0) {
            n = n.getNextSibling();
        }
        if (n != null) {
            Element e = n.getOwnerDocument().createElement("xfa:datasets");
            e.setAttribute("xmlns:xfa", XFA_DATA_SCHEMA);
            this.datasetsNode = e;
            n.appendChild(this.datasetsNode);
        }
    }

    private Node getFirstElementNode(Node src) {
        Node result = null;
        NodeList list = src.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            result = list.item(i);
            break;
        }
        return result;
    }

    private Node findDataNode(Node datasetsNode) {
        NodeList childNodes = datasetsNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!childNodes.item(i).getNodeName().equals("xfa:data")) continue;
            return childNodes.item(i);
        }
        return null;
    }
}

