/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.constants.FontWeights;
import java.util.List;
import java.util.Map;

public class FontNames {
    protected Map<Integer, List<String[]>> allNames;
    private String[][] fullName;
    private String[][] familyName;
    private String[][] subfamily;
    private String fontName;
    private String style = "";
    private String cidFontName;
    private int weight = 400;
    private String fontStretch = "Normal";
    private int macStyle;
    private boolean allowEmbedding;

    public String[][] getNames(int id) {
        List<String[]> names = this.allNames.get(id);
        return names != null && names.size() > 0 ? this.listToArray(names) : (String[][])null;
    }

    public String[][] getFullName() {
        return this.fullName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getCidFontName() {
        return this.cidFontName;
    }

    public String[][] getFamilyName() {
        return this.familyName;
    }

    public String getStyle() {
        return this.style;
    }

    public String getSubfamily() {
        return this.subfamily != null ? this.subfamily[0][3] : "";
    }

    public int getFontWeight() {
        return this.weight;
    }

    protected void setFontWeight(int weight) {
        this.weight = FontWeights.normalizeFontWeight(weight);
    }

    public String getFontStretch() {
        return this.fontStretch;
    }

    protected void setFontStretch(String fontStretch) {
        this.fontStretch = fontStretch;
    }

    public boolean allowEmbedding() {
        return this.allowEmbedding;
    }

    public boolean isBold() {
        return (this.macStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.macStyle & 2) != 0;
    }

    public boolean isUnderline() {
        return (this.macStyle & 4) != 0;
    }

    public boolean isOutline() {
        return (this.macStyle & 8) != 0;
    }

    public boolean isShadow() {
        return (this.macStyle & 0x10) != 0;
    }

    public boolean isCondensed() {
        return (this.macStyle & 0x20) != 0;
    }

    public boolean isExtended() {
        return (this.macStyle & 0x40) != 0;
    }

    protected void setAllNames(Map<Integer, List<String[]>> allNames) {
        this.allNames = allNames;
    }

    protected void setFullName(String[][] fullName) {
        this.fullName = fullName;
    }

    protected void setFullName(String fullName) {
        this.fullName = new String[][]{{"", "", "", fullName}};
    }

    protected void setFontName(String psFontName) {
        this.fontName = psFontName;
    }

    protected void setCidFontName(String cidFontName) {
        this.cidFontName = cidFontName;
    }

    protected void setFamilyName(String[][] familyName) {
        this.familyName = familyName;
    }

    protected void setFamilyName(String familyName) {
        this.familyName = new String[][]{{"", "", "", familyName}};
    }

    protected void setStyle(String style) {
        this.style = style;
    }

    protected void setSubfamily(String subfamily) {
        this.subfamily = new String[][]{{"", "", "", subfamily}};
    }

    protected void setSubfamily(String[][] subfamily) {
        this.subfamily = subfamily;
    }

    protected void setMacStyle(int macStyle) {
        this.macStyle = macStyle;
    }

    protected int getMacStyle() {
        return this.macStyle;
    }

    protected void setAllowEmbedding(boolean allowEmbedding) {
        this.allowEmbedding = allowEmbedding;
    }

    private String[][] listToArray(List<String[]> list) {
        String[][] array = new String[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public String toString() {
        String name = this.getFontName();
        return name != null && name.length() > 0 ? name : super.toString();
    }
}

