/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfPage;

class PdfPages
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = 404629033132277362L;
    private int from;
    private PdfNumber count;
    private final PdfArray kids;
    private final PdfPages parent;

    public PdfPages(int from, PdfDocument pdfDocument, PdfPages parent) {
        super(new PdfDictionary());
        if (pdfDocument.getWriter() != null) {
            ((PdfDictionary)this.getPdfObject()).makeIndirect(pdfDocument);
        }
        this.setForbidRelease();
        this.from = from;
        this.count = new PdfNumber(0);
        this.kids = new PdfArray();
        this.parent = parent;
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Pages);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Kids, this.kids);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Count, this.count);
        if (parent != null) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Parent, (PdfObject)this.parent.getPdfObject());
        }
    }

    public PdfPages(int from, PdfDocument pdfDocument) {
        this(from, pdfDocument, null);
    }

    public PdfPages(int from, int maxCount, PdfDictionary pdfObject, PdfPages parent) {
        super(pdfObject);
        this.setForbidRelease();
        this.from = from;
        this.count = pdfObject.getAsNumber(PdfName.Count);
        this.parent = parent;
        if (this.count == null) {
            this.count = new PdfNumber(1);
            pdfObject.put(PdfName.Count, this.count);
        } else if (maxCount < this.count.intValue()) {
            this.count.setValue(maxCount);
        }
        this.kids = pdfObject.getAsArray(PdfName.Kids);
        pdfObject.put(PdfName.Type, PdfName.Pages);
    }

    public void addPage(PdfDictionary page) {
        this.kids.add(page);
        this.incrementCount();
        page.put(PdfName.Parent, (PdfObject)this.getPdfObject());
        page.setModified();
    }

    public boolean addPage(int index, PdfPage pdfPage) {
        if (index < this.from || index > this.from + this.getCount()) {
            return false;
        }
        this.kids.add(index - this.from, (PdfObject)pdfPage.getPdfObject());
        ((PdfDictionary)pdfPage.getPdfObject()).put(PdfName.Parent, (PdfObject)this.getPdfObject());
        pdfPage.setModified();
        this.incrementCount();
        return true;
    }

    public boolean removePage(int pageNum) {
        if (pageNum < this.from || pageNum >= this.from + this.getCount()) {
            return false;
        }
        this.decrementCount();
        this.kids.remove(pageNum - this.from);
        return true;
    }

    public void addPages(PdfPages pdfPages) {
        this.kids.add((PdfObject)pdfPages.getPdfObject());
        this.count.setValue(this.count.intValue() + pdfPages.getCount());
        ((PdfDictionary)pdfPages.getPdfObject()).put(PdfName.Parent, (PdfObject)this.getPdfObject());
        pdfPages.setModified();
        this.setModified();
    }

    public void removeFromParent() {
        if (this.parent != null) {
            assert (this.getCount() == 0);
            this.parent.kids.remove(((PdfDictionary)this.getPdfObject()).getIndirectReference());
            if (this.parent.getCount() == 0) {
                this.parent.removeFromParent();
            }
        }
    }

    public int getFrom() {
        return this.from;
    }

    public int getCount() {
        return this.count.intValue();
    }

    public void correctFrom(int correction) {
        this.from += correction;
    }

    public PdfArray getKids() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Kids);
    }

    public PdfPages getParent() {
        return this.parent;
    }

    public void incrementCount() {
        this.count.increment();
        this.setModified();
        if (this.parent != null) {
            this.parent.incrementCount();
        }
    }

    public void decrementCount() {
        this.count.decrement();
        this.setModified();
        if (this.parent != null) {
            this.parent.decrementCount();
        }
    }

    public int compareTo(int index) {
        if (index < this.from) {
            return 1;
        }
        if (index >= this.from + this.getCount()) {
            return -1;
        }
        return 0;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }
}

