/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.exceptions.BadPasswordException;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfObject {
    public static final byte ARRAY = 1;
    public static final byte BOOLEAN = 2;
    public static final byte DICTIONARY = 3;
    public static final byte LITERAL = 4;
    public static final byte INDIRECT_REFERENCE = 5;
    public static final byte NAME = 6;
    public static final byte NULL = 7;
    public static final byte NUMBER = 8;
    public static final byte STREAM = 9;
    public static final byte STRING = 10;
    protected static final short FLUSHED = 1;
    protected static final short FREE = 2;
    protected static final short READING = 4;
    protected static final short MODIFIED = 8;
    protected static final short ORIGINAL_OBJECT_STREAM = 16;
    protected static final short MUST_BE_FLUSHED = 32;
    protected static final short MUST_BE_INDIRECT = 64;
    protected static final short FORBID_RELEASE = 128;
    protected static final short READ_ONLY = 256;
    protected static final short UNENCRYPTED = 512;
    protected PdfIndirectReference indirectReference = null;
    private short state;

    public abstract byte getType();

    public final void flush() {
        this.flush(true);
    }

    public final void flush(boolean canBeInObjStm) {
        if (this.isFlushed() || this.getIndirectReference() == null || this.getIndirectReference().isFree()) {
            return;
        }
        try {
            PdfDocument document = this.getIndirectReference().getDocument();
            if (document != null) {
                if (document.isAppendMode() && !this.isModified()) {
                    Logger logger = LoggerFactory.getLogger(PdfObject.class);
                    logger.info("PdfObject flushing is not performed: PdfDocument is opened in append mode and the object is not marked as modified ( see PdfObject#setModified() ).");
                    return;
                }
                document.checkIsoConformance(this, IsoKey.PDF_OBJECT);
                document.flushObject(this, canBeInObjStm && this.getType() != 9 && this.getType() != 5 && this.getIndirectReference().getGenNumber() == 0);
            }
        }
        catch (IOException e) {
            throw new PdfException("Cannot flush object.", e, this);
        }
    }

    public PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    public boolean isIndirect() {
        return this.indirectReference != null || this.checkState((short)64);
    }

    public PdfObject makeIndirect(PdfDocument document, PdfIndirectReference reference) {
        if (document == null || this.indirectReference != null) {
            return this;
        }
        if (document.getWriter() == null) {
            throw new PdfException("There is no associate PdfWriter for making indirects.");
        }
        if (reference == null) {
            this.indirectReference = document.createNextIndirectReference();
            this.indirectReference.setRefersTo(this);
        } else {
            reference.setState((short)8);
            this.indirectReference = reference;
            this.indirectReference.setRefersTo(this);
        }
        this.setState((short)128);
        this.clearState((short)64);
        return this;
    }

    public PdfObject makeIndirect(PdfDocument document) {
        return this.makeIndirect(document, null);
    }

    public boolean isFlushed() {
        PdfIndirectReference indirectReference = this.getIndirectReference();
        return indirectReference != null && indirectReference.checkState((short)1);
    }

    public boolean isModified() {
        PdfIndirectReference indirectReference = this.getIndirectReference();
        return indirectReference != null && indirectReference.checkState((short)8);
    }

    public PdfObject clone() {
        PdfObject newObject = this.newInstance();
        if (this.indirectReference != null || this.checkState((short)64)) {
            newObject.setState((short)64);
        }
        newObject.copyContent(this, null);
        return newObject;
    }

    public PdfObject copyTo(PdfDocument document) {
        return this.copyTo(document, true);
    }

    public PdfObject copyTo(PdfDocument document, boolean allowDuplicating) {
        if (document == null) {
            throw new PdfException("Document for copyTo cannot be null.");
        }
        if (this.indirectReference != null) {
            if (this.indirectReference.getWriter() != null || this.checkState((short)64)) {
                throw new PdfException("Cannot copy indirect object from the document that is being written.");
            }
            if (!this.indirectReference.getReader().isOpenedWithFullPermission()) {
                throw new BadPasswordException("PdfReader is not opened with owner password");
            }
        }
        return this.processCopying(document, allowDuplicating);
    }

    public PdfObject setModified() {
        if (this.indirectReference != null) {
            this.indirectReference.setState((short)8);
            this.setState((short)128);
        }
        return this;
    }

    public boolean isReleaseForbidden() {
        return this.checkState((short)128);
    }

    public void release() {
        if (this.isReleaseForbidden()) {
            Logger logger = LoggerFactory.getLogger(PdfObject.class);
            logger.warn("ForbidRelease flag is set and release is called. Releasing will not be performed.");
        } else if (this.indirectReference != null && this.indirectReference.getReader() != null && !this.indirectReference.checkState((short)1)) {
            this.indirectReference.refersTo = null;
            this.indirectReference = null;
            this.setState((short)256);
        }
    }

    public boolean isNull() {
        return this.getType() == 7;
    }

    public boolean isBoolean() {
        return this.getType() == 2;
    }

    public boolean isNumber() {
        return this.getType() == 8;
    }

    public boolean isString() {
        return this.getType() == 10;
    }

    public boolean isName() {
        return this.getType() == 6;
    }

    public boolean isArray() {
        return this.getType() == 1;
    }

    public boolean isDictionary() {
        return this.getType() == 3;
    }

    public boolean isStream() {
        return this.getType() == 9;
    }

    public boolean isIndirectReference() {
        return this.getType() == 5;
    }

    public boolean isLiteral() {
        return this.getType() == 4;
    }

    protected abstract PdfObject newInstance();

    protected PdfObject setIndirectReference(PdfIndirectReference indirectReference) {
        this.indirectReference = indirectReference;
        return this;
    }

    protected boolean checkState(short state) {
        return (this.state & state) == state;
    }

    protected PdfObject setState(short state) {
        this.state = (short)(this.state | state);
        return this;
    }

    protected PdfObject clearState(short state) {
        this.state = (short)(this.state & (short)(~state));
        return this;
    }

    protected void copyContent(PdfObject from, PdfDocument document) {
        if (this.isFlushed()) {
            throw new PdfException("Cannot copy flushed object.", this);
        }
    }

    PdfObject processCopying(PdfDocument documentTo, boolean allowDuplicating) {
        if (documentTo != null) {
            PdfWriter writer = documentTo.getWriter();
            if (writer == null) {
                throw new PdfException("Cannot copy to document opened in reading mode.");
            }
            return writer.copyObject(this, documentTo, allowDuplicating);
        }
        PdfObject obj = this;
        if (obj.isIndirectReference()) {
            PdfObject refTo = ((PdfIndirectReference)obj).getRefersTo();
            PdfObject pdfObject = obj = refTo != null ? refTo : obj;
        }
        if (obj.isIndirect() && !allowDuplicating) {
            return obj;
        }
        return obj.clone();
    }

    static boolean equalContent(PdfObject obj1, PdfObject obj2) {
        PdfObject direct1 = obj1 != null && obj1.isIndirectReference() ? ((PdfIndirectReference)obj1).getRefersTo(true) : obj1;
        PdfObject direct2 = obj2 != null && obj2.isIndirectReference() ? ((PdfIndirectReference)obj2).getRefersTo(true) : obj2;
        return direct1 != null && direct1.equals(direct2);
    }
}

