/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.colors.gradients;

import java.util.Arrays;
import java.util.Objects;

public class GradientColorStop {
    private final float[] rgb;
    private final float opacity;
    private OffsetType offsetType;
    private double offset;
    private double hintOffset = 0.0;
    private HintOffsetType hintOffsetType = HintOffsetType.NONE;

    public GradientColorStop(float[] rgb) {
        this(rgb, 1.0f, 0.0, OffsetType.AUTO);
    }

    public GradientColorStop(float[] rgb, double offset, OffsetType offsetType) {
        this(rgb, 1.0f, offset, offsetType);
    }

    public GradientColorStop(GradientColorStop gradientColorStop, double offset, OffsetType offsetType) {
        this(gradientColorStop.getRgbArray(), gradientColorStop.getOpacity(), offset, offsetType);
    }

    private GradientColorStop(float[] rgb, float opacity, double offset, OffsetType offsetType) {
        this.rgb = GradientColorStop.copyRgbArray(rgb);
        this.opacity = GradientColorStop.normalize(opacity);
        this.setOffset(offset, offsetType);
    }

    public float[] getRgbArray() {
        return GradientColorStop.copyRgbArray(this.rgb);
    }

    private float getOpacity() {
        return this.opacity;
    }

    public OffsetType getOffsetType() {
        return this.offsetType;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getHintOffset() {
        return this.hintOffset;
    }

    public HintOffsetType getHintOffsetType() {
        return this.hintOffsetType;
    }

    public GradientColorStop setOffset(double offset, OffsetType offsetType) {
        this.offsetType = offsetType != null ? offsetType : OffsetType.AUTO;
        this.offset = this.offsetType != OffsetType.AUTO ? offset : 0.0;
        return this;
    }

    public GradientColorStop setHint(double hintOffset, HintOffsetType hintOffsetType) {
        this.hintOffsetType = hintOffsetType != null ? hintOffsetType : HintOffsetType.NONE;
        this.hintOffset = this.hintOffsetType != HintOffsetType.NONE ? hintOffset : 0.0;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradientColorStop that = (GradientColorStop)o;
        return Float.compare(that.opacity, this.opacity) == 0 && Double.compare(that.offset, this.offset) == 0 && Double.compare(that.hintOffset, this.hintOffset) == 0 && Arrays.equals(this.rgb, that.rgb) && this.offsetType == that.offsetType && this.hintOffsetType == that.hintOffsetType;
    }

    public int hashCode() {
        int result = Objects.hash(Float.valueOf(this.opacity), this.offset, this.hintOffset);
        result = 31 * result + this.offsetType.hashCode();
        result = 31 * result + this.hintOffsetType.hashCode();
        result = 31 * result + Arrays.hashCode(this.rgb);
        return result;
    }

    private static float normalize(float toNormalize) {
        return toNormalize > 1.0f ? 1.0f : (toNormalize > 0.0f ? toNormalize : 0.0f);
    }

    private static float[] copyRgbArray(float[] toCopy) {
        if (toCopy == null || toCopy.length < 3) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return new float[]{GradientColorStop.normalize(toCopy[0]), GradientColorStop.normalize(toCopy[1]), GradientColorStop.normalize(toCopy[2])};
    }

    public static enum HintOffsetType {
        ABSOLUTE_ON_GRADIENT,
        RELATIVE_ON_GRADIENT,
        RELATIVE_BETWEEN_COLORS,
        NONE;

    }

    public static enum OffsetType {
        ABSOLUTE,
        AUTO,
        RELATIVE;

    }
}

