/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.annot.BorderStyleUtil;
import com.itextpdf.kernel.pdf.annot.InteriorColorUtil;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;

public class PdfCircleAnnotation
extends PdfMarkupAnnotation {
    public PdfCircleAnnotation(Rectangle rect) {
        super(rect);
    }

    protected PdfCircleAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.Circle;
    }

    public PdfDictionary getBorderStyle() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BS);
    }

    public PdfCircleAnnotation setBorderStyle(PdfDictionary borderStyle) {
        return (PdfCircleAnnotation)this.put(PdfName.BS, borderStyle);
    }

    public PdfCircleAnnotation setBorderStyle(PdfName style) {
        return this.setBorderStyle(BorderStyleUtil.setStyle(this.getBorderStyle(), style));
    }

    public PdfCircleAnnotation setDashPattern(PdfArray dashPattern) {
        return this.setBorderStyle(BorderStyleUtil.setDashPattern(this.getBorderStyle(), dashPattern));
    }

    public PdfArray getRectangleDifferences() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.RD);
    }

    public PdfCircleAnnotation setRectangleDifferences(PdfArray rect) {
        return (PdfCircleAnnotation)this.put(PdfName.RD, rect);
    }

    public PdfDictionary getBorderEffect() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.BE);
    }

    public PdfCircleAnnotation setBorderEffect(PdfDictionary borderEffect) {
        return (PdfCircleAnnotation)this.put(PdfName.BE, borderEffect);
    }

    public Color getInteriorColor() {
        return InteriorColorUtil.parseInteriorColor(((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.IC));
    }

    public PdfCircleAnnotation setInteriorColor(PdfArray interiorColor) {
        return (PdfCircleAnnotation)this.put(PdfName.IC, interiorColor);
    }

    public PdfCircleAnnotation setInteriorColor(float[] interiorColor) {
        return this.setInteriorColor(new PdfArray(interiorColor));
    }
}

