/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.AlignmentPropertyValue;
import com.itextpdf.layout.properties.FlexWrapPropertyValue;
import com.itextpdf.layout.properties.JustifyContent;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.FlexContainerRenderer;
import com.itextpdf.layout.renderer.FlexItemInfo;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FlexUtil {
    private static final float EPSILON = 1.0E-4f;
    private static final float FLEX_GROW_INITIAL_VALUE = 0.0f;
    private static final float FLEX_SHRINK_INITIAL_VALUE = 1.0f;
    private static Logger logger = LoggerFactory.getLogger(FlexUtil.class);

    private FlexUtil() {
    }

    public static List<List<FlexItemInfo>> calculateChildrenRectangles(Rectangle flexContainerBBox, FlexContainerRenderer flexContainerRenderer) {
        Rectangle layoutBox = flexContainerBBox.clone();
        flexContainerRenderer.applyMarginsBordersPaddings(layoutBox, false);
        Float mainSize = flexContainerRenderer.retrieveWidth(layoutBox.getWidth());
        if (mainSize == null) {
            mainSize = Float.valueOf(layoutBox.getWidth());
        }
        Float crossSize = flexContainerRenderer.retrieveHeight();
        Float minCrossSize = flexContainerRenderer.retrieveMinHeight();
        Float maxCrossSize = flexContainerRenderer.retrieveMaxHeight();
        List<FlexItemCalculationInfo> flexItemCalculationInfos = FlexUtil.createFlexItemCalculationInfos(flexContainerRenderer, mainSize.floatValue());
        FlexUtil.determineFlexBasisAndHypotheticalMainSizeForFlexItems(flexItemCalculationInfos);
        boolean isSingleLine = !flexContainerRenderer.hasProperty(128) || FlexWrapPropertyValue.NOWRAP == flexContainerRenderer.getProperty(128);
        List<List<FlexItemCalculationInfo>> lines = FlexUtil.collectFlexItemsIntoFlexLines(flexItemCalculationInfos, mainSize.floatValue(), isSingleLine);
        FlexUtil.resolveFlexibleLengths(lines, mainSize.floatValue());
        FlexUtil.determineHypotheticalCrossSizeForFlexItems(lines);
        List<Float> lineCrossSizes = FlexUtil.calculateCrossSizeOfEachFlexLine(lines, isSingleLine, minCrossSize, crossSize, maxCrossSize);
        float flexLinesCrossSizesSum = 0.0f;
        for (float size : lineCrossSizes) {
            flexLinesCrossSizesSum += size;
        }
        FlexUtil.handleAlignContentStretch(flexContainerRenderer, crossSize, flexLinesCrossSizesSum, lineCrossSizes);
        FlexUtil.determineUsedCrossSizeOfEachFlexItem(lines, lineCrossSizes, flexContainerRenderer);
        FlexUtil.applyJustifyContent(lines, flexContainerRenderer, mainSize.floatValue());
        FlexUtil.applyAlignItemsAndAlignSelf(lines, flexContainerRenderer, lineCrossSizes);
        ArrayList<List<FlexItemInfo>> layoutTable = new ArrayList<List<FlexItemInfo>>();
        for (List<FlexItemCalculationInfo> line : lines) {
            ArrayList<FlexItemInfo> layoutLine = new ArrayList<FlexItemInfo>();
            for (FlexItemCalculationInfo info : line) {
                layoutLine.add(new FlexItemInfo(info.renderer, info.toRectangle()));
            }
            layoutTable.add(layoutLine);
        }
        return layoutTable;
    }

    static void determineFlexBasisAndHypotheticalMainSizeForFlexItems(List<FlexItemCalculationInfo> flexItemCalculationInfos) {
        for (FlexItemCalculationInfo info : flexItemCalculationInfos) {
            AbstractRenderer renderer = info.renderer;
            Float rendererHeight = renderer.retrieveHeight();
            if (renderer.hasAspectRatio() && info.flexBasisContent && rendererHeight != null) {
                float aspectRatio = renderer.getAspectRatio().floatValue();
                info.flexBaseSize = rendererHeight.floatValue() * aspectRatio;
            } else {
                info.flexBaseSize = info.flexBasis;
            }
            info.mainSize = info.hypotheticalMainSize = Math.max(0.0f, Math.min(Math.max(info.minContent, info.flexBaseSize), info.maxContent));
        }
    }

    static List<List<FlexItemCalculationInfo>> collectFlexItemsIntoFlexLines(List<FlexItemCalculationInfo> flexItemCalculationInfos, float mainSize, boolean isSingleLine) {
        ArrayList<List<FlexItemCalculationInfo>> lines = new ArrayList<List<FlexItemCalculationInfo>>();
        ArrayList<FlexItemCalculationInfo> currentLineInfos = new ArrayList<FlexItemCalculationInfo>();
        if (isSingleLine) {
            currentLineInfos.addAll(flexItemCalculationInfos);
        } else {
            float occupiedLineSpace = 0.0f;
            for (FlexItemCalculationInfo info : flexItemCalculationInfos) {
                if ((occupiedLineSpace += info.getOuterMainSize(info.hypotheticalMainSize)) > mainSize + 1.0E-4f) {
                    if (currentLineInfos.isEmpty()) {
                        currentLineInfos.add(info);
                        lines.add(currentLineInfos);
                        currentLineInfos = new ArrayList();
                        occupiedLineSpace = 0.0f;
                        continue;
                    }
                    lines.add(currentLineInfos);
                    currentLineInfos = new ArrayList();
                    currentLineInfos.add(info);
                    occupiedLineSpace = info.hypotheticalMainSize;
                    continue;
                }
                currentLineInfos.add(info);
            }
        }
        if (!currentLineInfos.isEmpty()) {
            lines.add(currentLineInfos);
        }
        return lines;
    }

    static void resolveFlexibleLengths(List<List<FlexItemCalculationInfo>> lines, float mainSize) {
        for (List<FlexItemCalculationInfo> line : lines) {
            float hypotheticalMainSizesSum = 0.0f;
            for (FlexItemCalculationInfo flexItemCalculationInfo : line) {
                hypotheticalMainSizesSum += flexItemCalculationInfo.getOuterMainSize(flexItemCalculationInfo.hypotheticalMainSize);
            }
            boolean isFlexGrow = hypotheticalMainSizesSum < mainSize;
            for (FlexItemCalculationInfo info3 : line) {
                if (isFlexGrow) {
                    if (!FlexUtil.isZero(info3.flexGrow) && !(info3.flexBaseSize > info3.hypotheticalMainSize)) continue;
                    info3.mainSize = info3.hypotheticalMainSize;
                    info3.isFrozen = true;
                    continue;
                }
                if (!FlexUtil.isZero(info3.flexShrink) && !(info3.flexBaseSize < info3.hypotheticalMainSize)) continue;
                info3.mainSize = info3.hypotheticalMainSize;
                info3.isFrozen = true;
            }
            float f = FlexUtil.calculateFreeSpace(line, mainSize);
            while (FlexUtil.hasFlexibleItems(line)) {
                float remainingFreeSpace = FlexUtil.calculateFreeSpace(line, mainSize);
                float flexFactorSum = 0.0f;
                for (FlexItemCalculationInfo flexItemCalculationInfo : line) {
                    if (flexItemCalculationInfo.isFrozen) continue;
                    flexFactorSum += isFlexGrow ? flexItemCalculationInfo.flexGrow : flexItemCalculationInfo.flexShrink;
                }
                if (flexFactorSum < 1.0f && Math.abs(remainingFreeSpace) > Math.abs(f * flexFactorSum)) {
                    remainingFreeSpace = f * flexFactorSum;
                }
                if (!FlexUtil.isZero(remainingFreeSpace)) {
                    float ratio;
                    float scaledFlexShrinkFactorsSum = 0.0f;
                    for (FlexItemCalculationInfo info5 : line) {
                        if (info5.isFrozen) continue;
                        if (isFlexGrow) {
                            ratio = info5.flexGrow / flexFactorSum;
                            info5.mainSize = info5.flexBaseSize + remainingFreeSpace * ratio;
                            continue;
                        }
                        info5.scaledFlexShrinkFactor = info5.flexShrink * info5.flexBaseSize;
                        scaledFlexShrinkFactorsSum += info5.scaledFlexShrinkFactor;
                    }
                    if (!FlexUtil.isZero(scaledFlexShrinkFactorsSum)) {
                        for (FlexItemCalculationInfo info : line) {
                            if (info.isFrozen || isFlexGrow) continue;
                            ratio = info.scaledFlexShrinkFactor / scaledFlexShrinkFactorsSum;
                            info.mainSize = info.flexBaseSize - Math.abs(remainingFreeSpace) * ratio;
                        }
                    }
                } else {
                    for (FlexItemCalculationInfo flexItemCalculationInfo : line) {
                        if (flexItemCalculationInfo.isFrozen) continue;
                        flexItemCalculationInfo.mainSize = flexItemCalculationInfo.flexBaseSize;
                    }
                }
                float sum = 0.0f;
                for (FlexItemCalculationInfo info : line) {
                    if (info.isFrozen) continue;
                    float clampedSize = Math.min(Math.max(info.mainSize, info.minContent), info.maxContent);
                    if (info.mainSize > clampedSize) {
                        info.isMaxViolated = true;
                    } else if (info.mainSize < clampedSize) {
                        info.isMinViolated = true;
                    }
                    sum += clampedSize - info.mainSize;
                    info.mainSize = clampedSize;
                }
                for (FlexItemCalculationInfo info : line) {
                    if (info.isFrozen || !(FlexUtil.isZero(sum) || 0.0f < sum && info.isMinViolated) && (!(0.0f > sum) || !info.isMaxViolated)) continue;
                    info.isFrozen = true;
                }
            }
        }
    }

    static void determineHypotheticalCrossSizeForFlexItems(List<List<FlexItemCalculationInfo>> lines) {
        for (List<FlexItemCalculationInfo> line : lines) {
            for (FlexItemCalculationInfo info : line) {
                UnitValue prevWidth = info.renderer.replaceOwnProperty(77, UnitValue.createPointValue(info.mainSize));
                UnitValue prevMinWidth = info.renderer.replaceOwnProperty(80, null);
                LayoutResult result = info.renderer.layout(new LayoutContext(new LayoutArea(0, new Rectangle(1000000.0f, 1000000.0f))));
                info.renderer.returnBackOwnProperty(80, prevMinWidth);
                info.renderer.returnBackOwnProperty(77, prevWidth);
                if (result.getStatus() == 1) {
                    info.hypotheticalCrossSize = info.getInnerCrossSize(result.getOccupiedArea().getBBox().getHeight());
                    continue;
                }
                logger.error("Flex item layout result isn't full, but it must be. The cross size of the flex item will be 0.");
                info.hypotheticalCrossSize = 0.0f;
            }
        }
    }

    static List<Float> calculateCrossSizeOfEachFlexLine(List<List<FlexItemCalculationInfo>> lines, boolean isSingleLine, Float minCrossSize, Float crossSize, Float maxCrossSize) {
        ArrayList<Float> lineCrossSizes = new ArrayList<Float>();
        if (isSingleLine && crossSize != null && !lines.isEmpty()) {
            lineCrossSizes.add(Float.valueOf(crossSize.floatValue()));
        } else {
            for (List<FlexItemCalculationInfo> line : lines) {
                float flexLinesCrossSize = 0.0f;
                float largestHypotheticalCrossSize = 0.0f;
                for (FlexItemCalculationInfo info : line) {
                    if (largestHypotheticalCrossSize < info.getOuterCrossSize(info.hypotheticalCrossSize)) {
                        largestHypotheticalCrossSize = info.getOuterCrossSize(info.hypotheticalCrossSize);
                    }
                    flexLinesCrossSize = Math.max(0.0f, largestHypotheticalCrossSize);
                }
                if (isSingleLine && !lines.isEmpty()) {
                    if (null != minCrossSize) {
                        flexLinesCrossSize = Math.max(minCrossSize.floatValue(), flexLinesCrossSize);
                    }
                    if (null != maxCrossSize) {
                        flexLinesCrossSize = Math.min(maxCrossSize.floatValue(), flexLinesCrossSize);
                    }
                }
                lineCrossSizes.add(Float.valueOf(flexLinesCrossSize));
            }
        }
        return lineCrossSizes;
    }

    static void handleAlignContentStretch(FlexContainerRenderer flexContainerRenderer, Float crossSize, float flexLinesCrossSizesSum, List<Float> lineCrossSizes) {
        AlignmentPropertyValue alignContent = flexContainerRenderer.getProperty(130, AlignmentPropertyValue.STRETCH);
        if (crossSize != null && alignContent == AlignmentPropertyValue.STRETCH && flexLinesCrossSizesSum < crossSize.floatValue() - 1.0E-4f) {
            float addition = (crossSize.floatValue() - flexLinesCrossSizesSum) / (float)lineCrossSizes.size();
            for (int i = 0; i < lineCrossSizes.size(); ++i) {
                lineCrossSizes.set(i, Float.valueOf(lineCrossSizes.get(i).floatValue() + addition));
            }
        }
    }

    static void determineUsedCrossSizeOfEachFlexItem(List<List<FlexItemCalculationInfo>> lines, List<Float> lineCrossSizes, FlexContainerRenderer flexContainerRenderer) {
        AlignmentPropertyValue alignItems = flexContainerRenderer.getProperty(134, AlignmentPropertyValue.STRETCH);
        assert (lines.size() == lineCrossSizes.size());
        for (int i = 0; i < lines.size(); ++i) {
            for (FlexItemCalculationInfo info : lines.get(i)) {
                AbstractRenderer infoRenderer = info.renderer;
                AlignmentPropertyValue alignSelf = infoRenderer.getProperty(129, alignItems);
                if ((alignSelf == AlignmentPropertyValue.STRETCH || alignSelf == AlignmentPropertyValue.NORMAL) && info.renderer.getProperty(27) == null) {
                    Float minHeight;
                    info.crossSize = info.getInnerCrossSize(lineCrossSizes.get(i).floatValue());
                    Float maxHeight = infoRenderer.retrieveMaxHeight();
                    if (maxHeight != null) {
                        info.crossSize = Math.min(maxHeight.floatValue(), info.crossSize);
                    }
                    if ((minHeight = infoRenderer.retrieveMinHeight()) == null) continue;
                    info.crossSize = Math.max(minHeight.floatValue(), info.crossSize);
                    continue;
                }
                info.crossSize = info.hypotheticalCrossSize;
            }
        }
    }

    private static void applyAlignItemsAndAlignSelf(List<List<FlexItemCalculationInfo>> lines, FlexContainerRenderer renderer, List<Float> lineCrossSizes) {
        AlignmentPropertyValue itemsAlignment = renderer.getProperty(134, AlignmentPropertyValue.STRETCH);
        assert (lines.size() == lineCrossSizes.size());
        for (int i = 0; i < lines.size(); ++i) {
            float lineCrossSize = lineCrossSizes.get(i).floatValue();
            for (FlexItemCalculationInfo itemInfo : lines.get(i)) {
                AlignmentPropertyValue selfAlignment = itemInfo.renderer.getProperty(129, itemsAlignment);
                float freeSpace = lineCrossSize - itemInfo.getOuterCrossSize(itemInfo.crossSize);
                switch (selfAlignment) {
                    case SELF_END: 
                    case END: 
                    case FLEX_END: {
                        itemInfo.yShift = freeSpace;
                        break;
                    }
                    case CENTER: {
                        itemInfo.yShift = freeSpace / 2.0f;
                        break;
                    }
                }
            }
        }
    }

    private static void applyJustifyContent(List<List<FlexItemCalculationInfo>> lines, FlexContainerRenderer renderer, float mainSize) {
        JustifyContent justifyContent = renderer.getProperty(133, JustifyContent.FLEX_START);
        for (List<FlexItemCalculationInfo> line : lines) {
            float childrenWidth = 0.0f;
            for (FlexItemCalculationInfo itemInfo : line) {
                childrenWidth += itemInfo.getOuterMainSize(itemInfo.mainSize);
            }
            float freeSpace = mainSize - childrenWidth;
            switch (justifyContent) {
                case RIGHT: 
                case END: 
                case SELF_END: 
                case FLEX_END: {
                    line.get((int)0).xShift = freeSpace;
                    break;
                }
                case CENTER: {
                    line.get((int)0).xShift = freeSpace / 2.0f;
                    break;
                }
            }
        }
    }

    private static float calculateFreeSpace(List<FlexItemCalculationInfo> line, float initialFreeSpace) {
        float result = initialFreeSpace;
        for (FlexItemCalculationInfo info : line) {
            if (info.isFrozen) {
                result -= info.getOuterMainSize(info.mainSize);
                continue;
            }
            result -= info.getOuterMainSize(info.flexBaseSize);
        }
        return result;
    }

    private static boolean hasFlexibleItems(List<FlexItemCalculationInfo> line) {
        for (FlexItemCalculationInfo info : line) {
            if (info.isFrozen) continue;
            return true;
        }
        return false;
    }

    static boolean isZero(float value) {
        return Math.abs(value) < 1.0E-4f;
    }

    private static List<FlexItemCalculationInfo> createFlexItemCalculationInfos(FlexContainerRenderer flexContainerRenderer, float flexContainerWidth) {
        List<IRenderer> childRenderers = flexContainerRenderer.getChildRenderers();
        ArrayList<FlexItemCalculationInfo> flexItems = new ArrayList<FlexItemCalculationInfo>();
        for (IRenderer renderer : childRenderers) {
            float flexBasis;
            if (!(renderer instanceof AbstractRenderer)) continue;
            AbstractRenderer abstractRenderer = (AbstractRenderer)renderer;
            float maxWidth = FlexUtil.calculateMaxWidth(abstractRenderer, flexContainerWidth);
            boolean flexBasisContent = false;
            if (renderer.getProperty(131) == null) {
                flexBasis = maxWidth;
                flexBasisContent = true;
            } else {
                flexBasis = abstractRenderer.retrieveUnitValue(flexContainerWidth, 131).floatValue();
                if (AbstractRenderer.isBorderBoxSizing(abstractRenderer)) {
                    flexBasis -= AbstractRenderer.calculatePaddingBorderWidth(abstractRenderer);
                }
            }
            flexBasis = Math.max(flexBasis, 0.0f);
            float flexGrow = renderer.getProperty(132, Float.valueOf(0.0f)).floatValue();
            float flexShrink = renderer.getProperty(127, Float.valueOf(1.0f)).floatValue();
            FlexItemCalculationInfo flexItemInfo = new FlexItemCalculationInfo((AbstractRenderer)renderer, flexBasis, flexGrow, flexShrink, flexContainerWidth, flexBasisContent);
            flexItems.add(flexItemInfo);
        }
        return flexItems;
    }

    private static float calculateMaxWidth(AbstractRenderer flexItemRenderer, float flexContainerWidth) {
        Float maxWidth;
        if (flexItemRenderer instanceof TableRenderer) {
            maxWidth = Float.valueOf(flexItemRenderer.getMinMaxWidth().getMaxWidth());
            maxWidth = Float.valueOf(flexItemRenderer.applyMarginsBordersPaddings(new Rectangle(maxWidth.floatValue(), 0.0f), false).getWidth());
        } else {
            maxWidth = flexItemRenderer.retrieveWidth(flexContainerWidth);
            if (maxWidth == null) {
                maxWidth = flexItemRenderer.retrieveMaxWidth(flexContainerWidth);
            }
            if (maxWidth == null) {
                maxWidth = flexItemRenderer instanceof ImageRenderer ? Float.valueOf(((ImageRenderer)flexItemRenderer).getImageWidth()) : Float.valueOf(flexItemRenderer.applyMarginsBordersPaddings(new Rectangle(flexItemRenderer.getMinMaxWidth().getMaxWidth(), 0.0f), false).getWidth());
            }
        }
        return maxWidth.floatValue();
    }

    static class FlexItemCalculationInfo {
        AbstractRenderer renderer;
        float flexBasis;
        float flexShrink;
        float flexGrow;
        float minContent;
        float maxContent;
        float mainSize;
        float crossSize;
        float xShift;
        float yShift;
        float scaledFlexShrinkFactor;
        boolean isFrozen = false;
        boolean isMinViolated = false;
        boolean isMaxViolated = false;
        float flexBaseSize;
        float hypotheticalMainSize;
        float hypotheticalCrossSize;
        boolean flexBasisContent;

        public FlexItemCalculationInfo(AbstractRenderer renderer, float flexBasis, float flexGrow, float flexShrink, float areaWidth, boolean flexBasisContent) {
            this.flexBasisContent = flexBasisContent;
            this.renderer = renderer;
            this.flexBasis = flexBasis;
            if (flexShrink < 0.0f) {
                throw new IllegalArgumentException("Flex shrink cannot be negative.");
            }
            this.flexShrink = flexShrink;
            if (flexGrow < 0.0f) {
                throw new IllegalArgumentException("Flex grow cannot be negative.");
            }
            this.flexGrow = flexGrow;
            Float definiteMinContent = renderer.retrieveMinWidth(areaWidth);
            this.minContent = definiteMinContent == null ? this.calculateMinContentAuto(areaWidth) : definiteMinContent.floatValue();
            Float maxWidth = this.renderer.retrieveMaxWidth(areaWidth);
            this.maxContent = maxWidth == null ? 1000000.0f : maxWidth.floatValue();
        }

        public Rectangle toRectangle() {
            return new Rectangle(this.xShift, this.yShift, this.getOuterMainSize(this.mainSize), this.getOuterCrossSize(this.crossSize));
        }

        float getOuterMainSize(float size) {
            return this.renderer.applyMarginsBordersPaddings(new Rectangle(size, 0.0f), true).getWidth();
        }

        float getInnerMainSize(float size) {
            return this.renderer.applyMarginsBordersPaddings(new Rectangle(size, 0.0f), false).getWidth();
        }

        float getOuterCrossSize(float size) {
            return this.renderer.applyMarginsBordersPaddings(new Rectangle(0.0f, size), true).getHeight();
        }

        float getInnerCrossSize(float size) {
            return this.renderer.applyMarginsBordersPaddings(new Rectangle(0.0f, size), false).getHeight();
        }

        private float calculateMinContentAuto(float flexContainerWidth) {
            Float specifiedSizeSuggestion = this.calculateSpecifiedSizeSuggestion(flexContainerWidth);
            float contentSizeSuggestion = this.calculateContentSizeSuggestion(flexContainerWidth);
            if (this.renderer.hasAspectRatio() && specifiedSizeSuggestion == null) {
                Float transferredSizeSuggestion = this.calculateTransferredSizeSuggestion();
                if (transferredSizeSuggestion == null) {
                    return contentSizeSuggestion;
                }
                return Math.min(contentSizeSuggestion, transferredSizeSuggestion.floatValue());
            }
            if (specifiedSizeSuggestion == null) {
                return contentSizeSuggestion;
            }
            return Math.min(contentSizeSuggestion, specifiedSizeSuggestion.floatValue());
        }

        private Float calculateTransferredSizeSuggestion() {
            Float transferredSizeSuggestion = null;
            Float height = this.renderer.retrieveHeight();
            if (this.renderer.hasAspectRatio() && height != null) {
                transferredSizeSuggestion = Float.valueOf(height.floatValue() * this.renderer.getAspectRatio().floatValue());
                transferredSizeSuggestion = Float.valueOf(this.clampValueByCrossSizesConvertedThroughAspectRatio(transferredSizeSuggestion.floatValue()));
            }
            return transferredSizeSuggestion;
        }

        private Float calculateSpecifiedSizeSuggestion(float flexContainerWidth) {
            if (this.renderer.hasProperty(77)) {
                return this.renderer.retrieveWidth(flexContainerWidth);
            }
            return null;
        }

        private float calculateContentSizeSuggestion(float flexContainerWidth) {
            Float maxWidth;
            UnitValue rendererWidth = this.renderer.replaceOwnProperty(77, null);
            UnitValue rendererHeight = this.renderer.replaceOwnProperty(27, null);
            MinMaxWidth minMaxWidth = this.renderer.getMinMaxWidth();
            float minContentSize = this.getInnerMainSize(minMaxWidth.getMinWidth());
            this.renderer.returnBackOwnProperty(27, rendererHeight);
            this.renderer.returnBackOwnProperty(77, rendererWidth);
            if (this.renderer.hasAspectRatio()) {
                minContentSize = this.clampValueByCrossSizesConvertedThroughAspectRatio(minContentSize);
            }
            if ((maxWidth = this.renderer.retrieveMaxWidth(flexContainerWidth)) == null) {
                maxWidth = Float.valueOf(1000000.0f);
            }
            return Math.min(minContentSize, maxWidth.floatValue());
        }

        private float clampValueByCrossSizesConvertedThroughAspectRatio(float value) {
            Float minHeight;
            Float maxHeight = this.renderer.retrieveMaxHeight();
            if (maxHeight == null || !this.renderer.hasProperty(84)) {
                maxHeight = Float.valueOf(1000000.0f);
            }
            if ((minHeight = this.renderer.retrieveMinHeight()) == null || !this.renderer.hasProperty(85)) {
                minHeight = Float.valueOf(0.0f);
            }
            return Math.min(Math.max(minHeight.floatValue() * this.renderer.getAspectRatio().floatValue(), value), maxHeight.floatValue() * this.renderer.getAspectRatio().floatValue());
        }
    }
}

