/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.properties.LineHeight;
import com.itextpdf.layout.properties.RenderingMode;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.TextRenderer;

class LineHeightHelper {
    public static final int ASCENDER_INDEX = 0;
    public static final int DESCENDER_INDEX = 1;
    public static final int XHEIGHT_INDEX = 2;
    public static final int LEADING_INDEX = 3;
    private static final float DEFAULT_LINE_HEIGHT_COEFF = 1.15f;

    private LineHeightHelper() {
    }

    static float[] getActualAscenderDescender(AbstractRenderer renderer) {
        float[] result = LineHeightHelper.getActualFontInfo(renderer);
        return new float[]{result[0], result[1]};
    }

    static float[] getActualFontInfo(AbstractRenderer renderer) {
        float lineHeight = LineHeightHelper.calculateLineHeight(renderer);
        float[] fontAscenderDescender = LineHeightHelper.getFontAscenderDescenderNormalized(renderer);
        float leading = lineHeight - (fontAscenderDescender[0] - fontAscenderDescender[1]);
        float ascender = fontAscenderDescender[0] + leading / 2.0f;
        float descender = fontAscenderDescender[1] - leading / 2.0f;
        return new float[]{ascender, descender, fontAscenderDescender[2], leading};
    }

    static float[] getFontAscenderDescenderNormalized(AbstractRenderer renderer) {
        PdfFont font = renderer.resolveFirstPdfFont();
        float fontSize = renderer.getPropertyAsUnitValue(24).getValue();
        float[] fontAscenderDescenderFromMetrics = TextRenderer.calculateAscenderDescender(font, RenderingMode.HTML_MODE);
        float fontAscender = fontAscenderDescenderFromMetrics[0] / 1000.0f * fontSize;
        float fontDescender = fontAscenderDescenderFromMetrics[1] / 1000.0f * fontSize;
        float xHeight = (float)font.getFontProgram().getFontMetrics().getXHeight() / 1000.0f * fontSize;
        return new float[]{fontAscender, fontDescender, xHeight};
    }

    static float calculateLineHeight(AbstractRenderer renderer) {
        float lineHeightValue;
        LineHeight lineHeight = (LineHeight)renderer.getProperty(124);
        float fontSize = renderer.getPropertyAsUnitValue(24).getValue();
        if (lineHeight == null || lineHeight.isNormalValue() || lineHeight.getValue() < 0.0f) {
            lineHeightValue = 1.15f * fontSize;
            float[] fontAscenderDescender = LineHeightHelper.getFontAscenderDescenderNormalized(renderer);
            float fontAscenderDescenderSum = fontAscenderDescender[0] - fontAscenderDescender[1];
            if (fontAscenderDescenderSum > lineHeightValue) {
                lineHeightValue = fontAscenderDescenderSum;
            }
        } else {
            lineHeightValue = lineHeight.isFixedValue() ? lineHeight.getValue() : lineHeight.getValue() * fontSize;
        }
        return lineHeightValue;
    }
}

