/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.properties;

import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.HashMap;

public final class ContinuousContainer {
    private static final int[] PROPERTIES_NEEDED_FOR_CONTINUOUS_CONTAINER = new int[]{43, 10, 47, 9};
    private final HashMap<Integer, Object> properties = new HashMap();

    private ContinuousContainer(IRenderer renderer) {
        for (int property : PROPERTIES_NEEDED_FOR_CONTINUOUS_CONTAINER) {
            this.properties.put(property, renderer.getProperty(property));
        }
    }

    public static void clearPropertiesFromOverFlowRenderer(IPropertyContainer overFlowRenderer) {
        if (overFlowRenderer == null) {
            return;
        }
        if (Boolean.TRUE.equals(overFlowRenderer.getProperty(140))) {
            overFlowRenderer.setProperty(50, UnitValue.createPointValue(0.0f));
            overFlowRenderer.setProperty(46, UnitValue.createPointValue(0.0f));
            overFlowRenderer.setProperty(13, null);
        }
    }

    public static void setupContinuousContainerIfNeeded(AbstractRenderer blockRenderer) {
        if (Boolean.TRUE.equals(blockRenderer.getProperty(140))) {
            if (!blockRenderer.hasProperty(141)) {
                ContinuousContainer continuousContainer = new ContinuousContainer(blockRenderer);
                blockRenderer.setProperty(141, continuousContainer);
            }
            ContinuousContainer.clearPropertiesFromSplitRenderer(blockRenderer);
        }
    }

    private static void clearPropertiesFromSplitRenderer(AbstractRenderer blockRenderer) {
        if (blockRenderer == null) {
            return;
        }
        blockRenderer.setProperty(43, UnitValue.createPointValue(0.0f));
        blockRenderer.setProperty(10, null);
        blockRenderer.setProperty(47, UnitValue.createPointValue(0.0f));
    }

    public void reApplyProperties(AbstractRenderer blockRenderer) {
        for (int property : PROPERTIES_NEEDED_FOR_CONTINUOUS_CONTAINER) {
            blockRenderer.setProperty(property, this.properties.get(property));
        }
        Border allBorders = (Border)this.properties.get(9);
        Border bottomBorder = (Border)this.properties.get(10);
        if (allBorders != null && bottomBorder == null) {
            blockRenderer.setProperty(10, allBorders);
        }
    }
}

