/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.borders;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;

public class FixedDashedBorder
extends Border {
    public static final float DEFAULT_UNITS_VALUE = 3.0f;
    private final float unitsOn;
    private final float unitsOff;
    private final float phase;

    public FixedDashedBorder(float width) {
        this(ColorConstants.BLACK, width);
    }

    public FixedDashedBorder(Color color, float width) {
        this(color, width, 1.0f);
    }

    public FixedDashedBorder(Color color, float width, float opacity) {
        this(color, width, opacity, 3.0f, 3.0f, 0.0f);
    }

    public FixedDashedBorder(Color color, float width, float unitsOn, float unitsOff, float phase) {
        this(color, width, 1.0f, unitsOn, unitsOff, phase);
    }

    public FixedDashedBorder(Color color, float width, float opacity, float unitsOn, float unitsOff, float phase) {
        super(color, width, opacity);
        this.unitsOn = unitsOn;
        this.unitsOff = unitsOff;
        this.phase = phase;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float[] startingPoints = this.getStartingPointsForBorderSide(x1, y1, x2, y2, defaultSide);
        x1 = startingPoints[0];
        y1 = startingPoints[1];
        x2 = startingPoints[2];
        y2 = startingPoints[3];
        canvas.saveState().setLineWidth(this.width).setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineDash(this.unitsOn, this.unitsOff, this.phase).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float horizontalRadius1, float verticalRadius1, float horizontalRadius2, float verticalRadius2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        canvas.saveState().setLineWidth(this.width).setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineDash(this.unitsOn, this.unitsOff, this.phase);
        Rectangle boundingRectangle = new Rectangle(x1, y1, x2 - x1, y2 - y1);
        float[] horizontalRadii = new float[]{horizontalRadius1, horizontalRadius2};
        float[] verticalRadii = new float[]{verticalRadius1, verticalRadius2};
        this.drawDiscontinuousBorders(canvas, boundingRectangle, horizontalRadii, verticalRadii, defaultSide, borderWidthBefore, borderWidthAfter);
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide) {
        canvas.saveState().setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineDash(this.unitsOn, this.unitsOff, this.phase).setLineWidth(this.width).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }

    @Override
    public int getType() {
        return 9;
    }
}

