/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.processors.impl;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.layout.font.Range;
import com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import com.itextpdf.styledxmlparser.resolver.font.BasicFontProvider;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.css.SvgCssContext;
import com.itextpdf.svg.processors.ISvgConverterProperties;

public class SvgProcessorContext {
    private FontProvider fontProvider;
    private FontSet tempFonts;
    private final ResourceResolver resourceResolver;
    private MediaDeviceDescription deviceDescription;
    private final SvgCssContext cssContext;

    public SvgProcessorContext(ISvgConverterProperties converterProperties) {
        this.deviceDescription = converterProperties.getMediaDeviceDescription();
        if (this.deviceDescription == null) {
            this.deviceDescription = MediaDeviceDescription.getDefault();
        }
        this.fontProvider = converterProperties.getFontProvider();
        if (this.fontProvider == null) {
            this.fontProvider = new BasicFontProvider();
        }
        this.resourceResolver = new ResourceResolver(converterProperties.getBaseUri(), converterProperties.getResourceRetriever());
        this.cssContext = new SvgCssContext();
    }

    public FontProvider getFontProvider() {
        return this.fontProvider;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public MediaDeviceDescription getDeviceDescription() {
        return this.deviceDescription;
    }

    public FontSet getTempFonts() {
        return this.tempFonts;
    }

    public SvgCssContext getCssContext() {
        return this.cssContext;
    }

    public void addTemporaryFont(FontProgram fontProgram, String encoding, String alias, Range unicodeRange) {
        if (this.tempFonts == null) {
            this.tempFonts = new FontSet();
        }
        this.tempFonts.addFont(fontProgram, encoding, alias, unicodeRange);
    }

    public void addTemporaryFont(FontProgram fontProgram, String encoding, String alias) {
        if (this.tempFonts == null) {
            this.tempFonts = new FontSet();
        }
        this.tempFonts.addFont(fontProgram, encoding, alias);
    }

    public void addTemporaryFont(FontInfo fontInfo, String alias) {
        if (this.tempFonts == null) {
            this.tempFonts = new FontSet();
        }
        this.tempFonts.addFont(fontInfo, alias);
    }
}

