/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.mapper.resolver;

public class ObjectMapperResolver {
    private static final boolean isJackson1Present = ObjectMapperResolver.existInCP("org.codehaus.jackson.map.ObjectMapper") && ObjectMapperResolver.existInCP("org.codehaus.jackson.JsonGenerator");
    private static final boolean isJackson2Present = ObjectMapperResolver.existInCP("com.fasterxml.jackson.databind.ObjectMapper") && ObjectMapperResolver.existInCP("com.fasterxml.jackson.core.JsonGenerator");
    private static final boolean isJaxbPresent = ObjectMapperResolver.existInCP("javax.xml.bind.Binder");
    private static final boolean isGsonPresent = ObjectMapperResolver.existInCP("com.google.gson.Gson");

    private static boolean existInCP(String className) {
        return ObjectMapperResolver.existsInCP(className, ObjectMapperResolver.class.getClassLoader()) || ObjectMapperResolver.existsInCP(className, Thread.currentThread().getContextClassLoader());
    }

    private static boolean existsInCP(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isJackson1InClassPath() {
        return isJackson1Present;
    }

    public static boolean isJackson2InClassPath() {
        return isJackson2Present;
    }

    public static boolean isJAXBInClassPath() {
        return isJaxbPresent;
    }

    public static boolean isGsonInClassPath() {
        return isGsonPresent;
    }
}

