/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.filter.log;

import com.jayway.restassured.filter.Filter;
import com.jayway.restassured.filter.FilterContext;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.internal.print.RequestPrinter;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.FilterableResponseSpecification;
import java.io.PrintStream;
import org.apache.commons.lang3.Validate;

public class RequestLoggingFilter
implements Filter {
    private final LogDetail logDetail;
    private final PrintStream stream;
    private final boolean shouldPrettyPrint;

    public RequestLoggingFilter() {
        this(LogDetail.ALL, System.out);
    }

    public RequestLoggingFilter(LogDetail logDetail) {
        this(logDetail, System.out);
    }

    public RequestLoggingFilter(PrintStream printStream) {
        this(LogDetail.ALL, printStream);
    }

    public RequestLoggingFilter(LogDetail logDetail, PrintStream stream) {
        this(logDetail, true, stream);
    }

    public RequestLoggingFilter(LogDetail logDetail, boolean shouldPrettyPrint, PrintStream stream) {
        Validate.notNull((Object)stream, (String)"Print stream cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)logDetail), (String)"Log details cannot be null", (Object[])new Object[0]);
        if (logDetail == LogDetail.STATUS) {
            throw new IllegalArgumentException(String.format("%s is not a valid %s for a request.", new Object[]{LogDetail.STATUS, LogDetail.class.getSimpleName()}));
        }
        this.stream = stream;
        this.logDetail = logDetail;
        this.shouldPrettyPrint = shouldPrettyPrint;
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        RequestPrinter.print(requestSpec, ctx.getRequestMethod().toString(), ctx.getCompleteRequestPath(), this.logDetail, this.stream, this.shouldPrettyPrint);
        return ctx.next(requestSpec, responseSpec);
    }

    public static RequestLoggingFilter logRequestTo(PrintStream stream) {
        return new RequestLoggingFilter(stream);
    }
}

