/*
 * Decompiled with CFR 0.152.
 */
package com.jeppeman.globallydynamic.globalsplitinstall;

import android.app.Activity;
import android.content.IntentSender;
import com.google.android.play.core.splitinstall.SplitInstallManager;
import com.google.android.play.core.splitinstall.SplitInstallSessionState;
import com.google.android.play.core.splitinstall.SplitInstallStateUpdatedListener;
import com.google.android.play.core.tasks.Task;
import com.jeppeman.globallydynamic.globalsplitinstall.GPlayGlobalSplitInstallRequestMapper;
import com.jeppeman.globallydynamic.globalsplitinstall.GPlayGlobalSplitInstallResultMapper;
import com.jeppeman.globallydynamic.globalsplitinstall.GPlayGlobalSplitInstallSessionStateMapper;
import com.jeppeman.globallydynamic.globalsplitinstall.GPlayGlobalSplitInstallTask;
import com.jeppeman.globallydynamic.globalsplitinstall.GlobalSplitInstallManager;
import com.jeppeman.globallydynamic.globalsplitinstall.GlobalSplitInstallRequest;
import com.jeppeman.globallydynamic.globalsplitinstall.GlobalSplitInstallSessionState;
import com.jeppeman.globallydynamic.globalsplitinstall.GlobalSplitInstallUpdatedListener;
import com.jeppeman.globallydynamic.tasks.GlobalSplitInstallTask;
import com.jeppeman.globallydynamic.tasks.GlobalSplitInstallTasks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class GPlayGlobalSplitInstallManager
implements GlobalSplitInstallManager {
    private final SplitInstallManager delegate;
    private final Map<GlobalSplitInstallUpdatedListener, SplitInstallStateUpdatedListener> listeners = new HashMap<GlobalSplitInstallUpdatedListener, SplitInstallStateUpdatedListener>();

    GPlayGlobalSplitInstallManager(SplitInstallManager delegate) {
        this.delegate = delegate;
    }

    public void registerListener(final GlobalSplitInstallUpdatedListener listener) {
        SplitInstallStateUpdatedListener installStateListener = new SplitInstallStateUpdatedListener(){

            public void onStateUpdate(SplitInstallSessionState installState) {
                listener.onStateUpdate(GPlayGlobalSplitInstallSessionStateMapper.toGlobalSplitInstallSessionState(installState));
            }
        };
        this.listeners.put(listener, installStateListener);
        this.delegate.registerListener(installStateListener);
    }

    public void unregisterListener(GlobalSplitInstallUpdatedListener listener) {
        SplitInstallStateUpdatedListener installStateListener = this.listeners.get(listener);
        if (installStateListener != null) {
            this.delegate.unregisterListener(installStateListener);
            this.listeners.remove(listener);
        }
    }

    public boolean startConfirmationDialogForResult(GlobalSplitInstallSessionState sessionState, Activity activity, int requestCode) throws IntentSender.SendIntentException {
        return this.delegate.startConfirmationDialogForResult(GPlayGlobalSplitInstallSessionStateMapper.toInstallState(sessionState), activity, requestCode);
    }

    public GlobalSplitInstallTask<Integer> startInstall(GlobalSplitInstallRequest request) {
        Task featureTask = this.delegate.startInstall(GPlayGlobalSplitInstallRequestMapper.toSplitInstallRequest(request));
        return new GPlayGlobalSplitInstallTask(featureTask);
    }

    public GlobalSplitInstallTask<Integer> installMissingSplits() {
        return GlobalSplitInstallTasks.empty((Object)0);
    }

    public GlobalSplitInstallTask<Void> cancelInstall(int sessionId) {
        return new GPlayGlobalSplitInstallTask(this.delegate.cancelInstall(sessionId));
    }

    public GlobalSplitInstallTask<Void> deferredInstall(List<String> moduleNames) {
        return new GPlayGlobalSplitInstallTask(this.delegate.deferredInstall(moduleNames));
    }

    public GlobalSplitInstallTask<Void> deferredUninstall(List<String> moduleNames) {
        return new GPlayGlobalSplitInstallTask(this.delegate.deferredUninstall(moduleNames));
    }

    public GlobalSplitInstallTask<Void> deferredLanguageInstall(List<Locale> languages) {
        return new GPlayGlobalSplitInstallTask(this.delegate.deferredLanguageInstall(languages));
    }

    public GlobalSplitInstallTask<Void> deferredLanguageUninstall(List<Locale> languages) {
        return new GPlayGlobalSplitInstallTask(this.delegate.deferredLanguageUninstall(languages));
    }

    public GlobalSplitInstallTask<GlobalSplitInstallSessionState> getSessionState(int sessionId) {
        return new GPlayGlobalSplitInstallTask<SplitInstallSessionState, GlobalSplitInstallSessionState>(this.delegate.getSessionState(sessionId), new GPlayGlobalSplitInstallResultMapper<SplitInstallSessionState, GlobalSplitInstallSessionState>(){

            @Override
            public GlobalSplitInstallSessionState map(SplitInstallSessionState from) {
                return GPlayGlobalSplitInstallSessionStateMapper.toGlobalSplitInstallSessionState(from);
            }
        });
    }

    public GlobalSplitInstallTask<List<GlobalSplitInstallSessionState>> getSessionStates() {
        return new GPlayGlobalSplitInstallTask<List<SplitInstallSessionState>, List<GlobalSplitInstallSessionState>>(this.delegate.getSessionStates(), new GPlayGlobalSplitInstallResultMapper<List<SplitInstallSessionState>, List<GlobalSplitInstallSessionState>>(){

            @Override
            public List<GlobalSplitInstallSessionState> map(List<SplitInstallSessionState> from) {
                ArrayList<GlobalSplitInstallSessionState> ret = new ArrayList<GlobalSplitInstallSessionState>(from.size());
                for (SplitInstallSessionState installState : from) {
                    ret.add(GPlayGlobalSplitInstallSessionStateMapper.toGlobalSplitInstallSessionState(installState));
                }
                return ret;
            }
        });
    }

    public Set<String> getInstalledLanguages() {
        return this.delegate.getInstalledLanguages();
    }

    public Set<String> getInstalledModules() {
        return this.delegate.getInstalledModules();
    }
}

