/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.kit.HashKit;
import java.util.List;
import java.util.UUID;

public class StrKit {
    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean notBlank(String str) {
        return !StrKit.isBlank(str);
    }

    public static boolean notBlank(String ... strings) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        for (String str : strings) {
            if (!StrKit.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasBlank(String ... strings) {
        if (strings == null || strings.length == 0) {
            return true;
        }
        for (String str : strings) {
            if (!StrKit.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static String defaultIfBlank(String str, String defaultValue) {
        return StrKit.isBlank(str) ? defaultValue : str;
    }

    public static String toCamelCase(String str) {
        return StrKit.toCamelCase(str, false);
    }

    public static String toCamelCase(String str, boolean toLowerCaseAnyway) {
        int i;
        int len = str.length();
        if (len <= 1) {
            return str;
        }
        int index = 0;
        char[] buf = new char[len];
        for (i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '_') {
                if (++i >= len) continue;
                ch = str.charAt(i);
                buf[index] = index == 0 ? Character.toLowerCase(ch) : Character.toUpperCase(ch);
                ++index;
                continue;
            }
            buf[index++] = Character.toLowerCase(ch);
        }
        if (toLowerCaseAnyway) {
            return new String(buf, 0, index);
        }
        return i == index ? str : new String(buf, 0, index);
    }

    public static String join(String[] stringArray) {
        StringBuilder sb = new StringBuilder();
        for (String s : stringArray) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] stringArray, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(stringArray[i]);
        }
        return sb.toString();
    }

    public static String join(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    public static boolean slowEquals(String a, String b) {
        byte[] aBytes = a != null ? a.getBytes() : null;
        byte[] bBytes = b != null ? b.getBytes() : null;
        return HashKit.slowEquals(aBytes, bBytes);
    }

    public static boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}

