/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.NullExpr;
import com.jfinal.template.stat.Scope;
import java.util.ArrayList;
import java.util.List;

public class ExprList
extends Expr {
    public static final Expr NULL_EXPR = NullExpr.me;
    public static final Expr[] NULL_EXPR_ARRAY = new Expr[0];
    public static final ExprList NULL_EXPR_LIST = new ExprList(new ArrayList<Expr>(0));
    public static final Object[] NULL_OBJECT_ARRAY = new Object[0];
    private Expr[] exprArray;

    public ExprList(List<Expr> exprList) {
        this.exprArray = exprList.size() > 0 ? exprList.toArray(new Expr[exprList.size()]) : NULL_EXPR_ARRAY;
    }

    public Expr getActualExpr() {
        if (this.exprArray.length == 1) {
            return this.exprArray[0];
        }
        if (this.exprArray.length == 0) {
            return NULL_EXPR;
        }
        return this;
    }

    public Expr[] getExprArray() {
        return this.exprArray;
    }

    public Expr getExpr(int index) {
        if (index < 0 || index >= this.exprArray.length) {
            throw new TemplateException("Index out of bounds: index = " + index + ", length = " + this.exprArray.length, this.location);
        }
        return this.exprArray[index];
    }

    public Expr getFirstExpr() {
        return this.exprArray.length > 0 ? this.exprArray[0] : null;
    }

    public Expr getLastExpr() {
        return this.exprArray.length > 0 ? this.exprArray[this.exprArray.length - 1] : null;
    }

    public int length() {
        return this.exprArray.length;
    }

    @Override
    public Object eval(Scope scope) {
        if (this.exprArray.length == 1) {
            return this.exprArray[0].eval(scope);
        }
        if (this.exprArray.length == 0) {
            return null;
        }
        int end = this.exprArray.length - 1;
        for (int i = 0; i < end; ++i) {
            this.exprArray[i].eval(scope);
        }
        return this.exprArray[end].eval(scope);
    }

    public Object[] evalExprList(Scope scope) {
        if (this.exprArray.length == 0) {
            return NULL_OBJECT_ARRAY;
        }
        Object[] ret = new Object[this.exprArray.length];
        for (int i = 0; i < this.exprArray.length; ++i) {
            ret[i] = this.exprArray[i].eval(scope);
        }
        return ret;
    }
}

