/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.client;

import com.librato.metrics.client.AbstractMeasure;
import com.librato.metrics.client.Maps;
import com.librato.metrics.client.Sanitizer;
import java.util.Map;

public class GaugeMeasure
extends AbstractMeasure {
    private String source;
    private Double value;
    private Double sum;
    private Double min;
    private Double max;
    private Double sumSquares;
    private Long count;

    public GaugeMeasure(String name, double value) {
        super(name);
        this.value = value;
    }

    public GaugeMeasure(String name, double sum, long count, double min, double max) {
        super(name);
        this.sum = sum;
        this.count = count;
        this.min = min;
        this.max = max;
    }

    public GaugeMeasure(String name, double sum, long count, double min, double max, double sumSquares) {
        super(name);
        this.sum = sum;
        this.count = count;
        this.min = min;
        this.max = max;
        this.sumSquares = sumSquares;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        Maps.putIfNotNull(map, "measure_time", this.epoch);
        Maps.putIfNotNull(map, "source", Sanitizer.LAST_PASS.apply(this.source));
        Maps.putIfNotNull(map, "value", this.value);
        Maps.putIfNotNull(map, "sum", this.sum);
        Maps.putIfNotNull(map, "count", this.count);
        Maps.putIfNotNull(map, "min", this.min);
        Maps.putIfNotNull(map, "max", this.max);
        Maps.putIfNotNull(map, "sum_squares", this.sumSquares);
        return map;
    }

    @Override
    public boolean isTagged() {
        return false;
    }

    @Override
    public boolean isGauge() {
        return true;
    }

    public GaugeMeasure setTime(long epochSeconds) {
        this.epoch = epochSeconds;
        return this;
    }

    public GaugeMeasure setSource(String source) {
        this.source = source;
        return this;
    }

    public GaugeMeasure setMetricAttributes(Map<String, Object> attributes) {
        this.metricAttributes = attributes;
        return this;
    }

    public GaugeMeasure setPeriod(int period) {
        this.period = period;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public Double getValue() {
        return this.value;
    }

    public Double getSum() {
        return this.sum;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public Double getSumSquares() {
        return this.sumSquares;
    }

    public Long getCount() {
        return this.count;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GaugeMeasure that = (GaugeMeasure)o;
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.sum != null ? !this.sum.equals(that.sum) : that.sum != null) {
            return false;
        }
        if (this.min != null ? !this.min.equals(that.min) : that.min != null) {
            return false;
        }
        if (this.max != null ? !this.max.equals(that.max) : that.max != null) {
            return false;
        }
        if (this.sumSquares != null ? !this.sumSquares.equals(that.sumSquares) : that.sumSquares != null) {
            return false;
        }
        return this.count != null ? this.count.equals(that.count) : that.count == null;
    }

    @Override
    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.sum != null ? this.sum.hashCode() : 0);
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        result = 31 * result + (this.sumSquares != null ? this.sumSquares.hashCode() : 0);
        result = 31 * result + (this.count != null ? this.count.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", source='").append(this.source).append('\'');
        sb.append(", value=").append(this.value);
        sb.append(", sum=").append(this.sum);
        sb.append(", min=").append(this.min);
        sb.append(", max=").append(this.max);
        sb.append(", sumSquares=").append(this.sumSquares);
        sb.append(", count=").append(this.count);
        sb.append('}');
        return sb.toString();
    }
}

