/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.brave;

import brave.SpanCustomizer;
import brave.http.HttpRequestParser;
import brave.http.HttpResponse;
import brave.http.HttpResponseParser;
import brave.propagation.TraceContext;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.brave.ClientRequestContextAdapter;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.logging.RequestLog;
import java.net.SocketAddress;

final class ArmeriaHttpClientParser
implements HttpRequestParser,
HttpResponseParser {
    private static final ArmeriaHttpClientParser INSTANCE = new ArmeriaHttpClientParser();

    static ArmeriaHttpClientParser get() {
        return INSTANCE;
    }

    private ArmeriaHttpClientParser() {
    }

    public void parse(brave.http.HttpRequest request, TraceContext context, SpanCustomizer span) {
        HttpRequestParser.DEFAULT.parse(request, context, span);
        Object unwrapped = request.unwrap();
        if (!(unwrapped instanceof ClientRequestContext)) {
            return;
        }
        ClientRequestContext ctx = (ClientRequestContext)unwrapped;
        HttpRequest httpReq = ctx.request();
        if (httpReq == null) {
            return;
        }
        span.tag("http.host", httpReq.authority()).tag("http.url", httpReq.uri().toString());
    }

    public void parse(HttpResponse response, TraceContext context, SpanCustomizer span) {
        String name;
        SocketAddress laddr;
        SocketAddress raddr;
        HttpResponseParser.DEFAULT.parse(response, context, span);
        Object res = response.unwrap();
        if (!(res instanceof ClientRequestContext)) {
            return;
        }
        ClientRequestContext ctx = (ClientRequestContext)res;
        RequestLog log = ctx.log().ensureComplete();
        span.tag("http.protocol", ClientRequestContextAdapter.protocol(log));
        String serFmt = ClientRequestContextAdapter.serializationFormat(log);
        if (serFmt != null) {
            span.tag("http.serfmt", serFmt);
        }
        if ((raddr = ctx.remoteAddress()) != null) {
            span.tag("address.remote", raddr.toString());
        }
        if ((laddr = ctx.localAddress()) != null) {
            span.tag("address.local", laddr.toString());
        }
        if ((name = log.name()) != null) {
            span.name(name);
        }
    }
}

