/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.brave;

import brave.SpanCustomizer;
import brave.http.HttpRequest;
import brave.http.HttpRequestParser;
import brave.http.HttpResponse;
import brave.http.HttpResponseParser;
import brave.propagation.TraceContext;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.brave.ServiceRequestContextAdapter;

final class ArmeriaHttpServerParser
implements HttpRequestParser,
HttpResponseParser {
    private static final ArmeriaHttpServerParser INSTANCE = new ArmeriaHttpServerParser();

    static ArmeriaHttpServerParser get() {
        return INSTANCE;
    }

    private ArmeriaHttpServerParser() {
    }

    public void parse(HttpRequest request, TraceContext context, SpanCustomizer span) {
        HttpRequestParser.DEFAULT.parse(request, context, span);
        Object unwrapped = request.unwrap();
        if (!(unwrapped instanceof ServiceRequestContext)) {
            return;
        }
        ServiceRequestContext ctx = (ServiceRequestContext)unwrapped;
        span.tag("http.host", ctx.request().authority()).tag("http.url", ctx.request().uri().toString()).tag("http.protocol", ctx.sessionProtocol().uriText()).tag("address.remote", ctx.remoteAddress().toString()).tag("address.local", ctx.localAddress().toString());
    }

    public void parse(HttpResponse response, TraceContext context, SpanCustomizer span) {
        String name;
        HttpResponseParser.DEFAULT.parse(response, context, span);
        Object res = response.unwrap();
        if (!(res instanceof ServiceRequestContext)) {
            return;
        }
        ServiceRequestContext ctx = (ServiceRequestContext)res;
        RequestLog requestLog = ctx.log().ensureComplete();
        String serFmt = ServiceRequestContextAdapter.serializationFormat(requestLog);
        if (serFmt != null) {
            span.tag("http.serfmt", serFmt);
        }
        if ((name = requestLog.name()) != null) {
            span.name(name);
        }
    }
}

