/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.chinese;

import com.luhuiguo.chinese.TrieNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trie<T> {
    private TrieNode<T> root = new TrieNode(' ');

    public void add(char[] w, T value) {
        if (w.length < 1) {
            return;
        }
        TrieNode<T> p = this.root;
        for (int i = 0; i < w.length; ++i) {
            TrieNode<T> n = p.child(w[i]);
            if (n == null) {
                n = p.addChild(w[i]);
            }
            p = n;
        }
        p.setLeaf(true);
        p.setValue(value);
    }

    public void add(String w, T value) {
        if (null == w) {
            return;
        }
        this.add(w.toCharArray(), value);
    }

    public TrieNode<T> match(char[] sen, int offset, int len) {
        TrieNode<T> node = this.root;
        for (int i = 0; i < len; ++i) {
            if ((node = node.child(sen[offset + i])) != null) continue;
            return null;
        }
        return node;
    }

    public TrieNode<T> bestMatch(char[] sen, int offset, int len) {
        TrieNode<T> ret = null;
        TrieNode<T> node = this.root;
        for (int i = offset; i < len && (node = node.child(sen[i])) != null; ++i) {
            if (!node.isLeaf()) continue;
            ret = node;
        }
        return ret;
    }

    public TrieNode<T> bestMatch(char[] sen, int offset) {
        return this.bestMatch(sen, offset, sen.length);
    }
}

