/*
 * Decompiled with CFR 0.152.
 */
package com.xiaogang.xxljobadminsdk.config;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.xiaogang.xxljobadminsdk.config.XxlJobAdminProperties;
import com.xiaogang.xxljobadminsdk.dto.HttpHeader;
import com.xiaogang.xxljobadminsdk.dto.ReturnT;
import com.xiaogang.xxljobadminsdk.service.XxlJobService;
import com.xiaogang.xxljobadminsdk.service.impl.XxlJobServiceImpl;
import com.xxl.job.core.biz.client.AdminBizClient;
import com.xxl.job.core.biz.model.RegistryParam;
import com.xxl.job.core.enums.RegistryConfig;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import com.xxl.job.core.util.IpUtil;
import com.xxl.job.core.util.NetUtil;
import java.net.HttpCookie;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={XxlJobAdminProperties.class})
public class XxlJobAdminAutoConfigure {
    private Logger logger = LoggerFactory.getLogger(XxlJobAdminAutoConfigure.class);

    @Bean(value={"loginHeader"})
    public HttpHeader httpRequest(XxlJobAdminProperties xxlJobAdminProperties) {
        this.logger.info(">>>>>>>>>>> xxl-job config init. httpRequest");
        String adminUrl = xxlJobAdminProperties.getAdminUrl();
        Assert.notBlank((CharSequence)adminUrl, (String)"\u8bf7\u914d\u7f6eadminUrl", (Object[])new Object[0]);
        String userName = xxlJobAdminProperties.getUserName();
        String password = xxlJobAdminProperties.getPassword();
        int connectionTimeOut = xxlJobAdminProperties.getConnectionTimeOut();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userName", userName);
        paramMap.put("password", password);
        HttpResponse httpResponse = null;
        try {
            httpResponse = HttpRequest.post((String)(adminUrl + "/login")).form(paramMap).timeout(connectionTimeOut).execute();
        }
        catch (Exception e) {
            Assert.isTrue((boolean)false, (String)"\u94fe\u63a5xxl-job\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5xxl-job\u670d\u52a1\u662f\u5426\u8fd0\u884c\u4ee5\u53ca\u5230xxl-job\u7684\u7f51\u7edc\u662f\u5426\u901a\u7545\u3002\u5f53\u524d\u94fe\u63a5\u5730\u5740\uff1a{}", (Object[])new Object[]{adminUrl});
        }
        int status = httpResponse.getStatus();
        Assert.isTrue((200 == status ? 1 : 0) != 0, (String)"\u767b\u5f55\u5931\u8d25,\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u5bc6\u7801\u662f\u5426\u6b63\u786e", (Object[])new Object[0]);
        String body = httpResponse.body();
        ReturnT returnT = (ReturnT)JSONUtil.toBean((String)body, ReturnT.class);
        Assert.isTrue((200 == returnT.getCode() ? 1 : 0) != 0, (String)"\u767b\u5f55\u5931\u8d25,\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u5bc6\u7801\u662f\u5426\u6b63\u786e", (Object[])new Object[0]);
        String cookieName = "XXL_JOB_LOGIN_IDENTITY";
        HttpCookie cookie = httpResponse.getCookie(cookieName);
        Assert.notNull((Object)cookie, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u767b\u5f55\u6210\u529f\u7684cookie\uff0c\u8bf7\u68c0\u67e5\u767b\u5f55\u8fde\u63a5\u6216\u8005\u53c2\u6570\u662f\u5426\u6b63\u786e", (Object[])new Object[0]);
        String headerValue = cookieName + "=" + cookie.getValue();
        HttpHeader loginHeader = new HttpHeader("Cookie", headerValue);
        return loginHeader;
    }

    @Bean
    public XxlJobService xxlJobService(HttpHeader loginHeader, XxlJobAdminProperties xxlJobAdminProperties) {
        this.logger.info(">>>>>>>>>>> xxl-job config init. xxlJobService");
        XxlJobServiceImpl xxlJobService = new XxlJobServiceImpl(loginHeader, xxlJobAdminProperties);
        return xxlJobService;
    }

    @Bean
    public XxlJobSpringExecutor xxlJobExecutor(XxlJobAdminProperties xxlJobAdminProperties) throws UnknownHostException {
        Integer logRetentionDays;
        String logPath;
        this.logger.info(">>>>>>>>>>> xxl-job config init. XxlJobSpringExecutor");
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        String adminUrl = xxlJobAdminProperties.getAdminUrl();
        Assert.notBlank((CharSequence)adminUrl, (String)"xxl-job\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        xxlJobSpringExecutor.setAdminAddresses(adminUrl);
        String appname = xxlJobAdminProperties.getAppname();
        Assert.notBlank((CharSequence)appname, (String)"\u8bf7\u914d\u7f6e\u6267\u884c\u5668\u53c2\u6570appname", (Object[])new Object[0]);
        xxlJobSpringExecutor.setAppname(appname);
        String address = xxlJobAdminProperties.getAddress();
        String ip = xxlJobAdminProperties.getIp();
        if (StrUtil.isBlank((CharSequence)ip)) {
            ip = IpUtil.getIp();
        }
        xxlJobSpringExecutor.setIp(ip);
        Integer port = xxlJobAdminProperties.getPort();
        if (port == null) {
            port = NetUtil.findAvailablePort((int)9999);
        }
        xxlJobSpringExecutor.setPort(port.intValue());
        if (StrUtil.isBlank((CharSequence)address)) {
            String ip_port_address = IpUtil.getIpPort((String)ip, (int)port);
            address = "http://{ip_port}/".replace("{ip_port}", ip_port_address);
        }
        xxlJobSpringExecutor.setAddress(address);
        String accessToken = xxlJobAdminProperties.getAccessToken();
        if (StrUtil.isNotBlank((CharSequence)accessToken)) {
            xxlJobSpringExecutor.setAccessToken(accessToken);
        }
        if (StrUtil.isNotBlank((CharSequence)(logPath = xxlJobAdminProperties.getLogPath()))) {
            xxlJobSpringExecutor.setLogPath(logPath);
        }
        if ((logRetentionDays = xxlJobAdminProperties.getLogRetentionDays()) != null) {
            xxlJobSpringExecutor.setLogRetentionDays(logRetentionDays.intValue());
        }
        RegistryParam registryParam = new RegistryParam(RegistryConfig.RegistType.EXECUTOR.name(), appname, address);
        AdminBizClient adminBiz = new AdminBizClient(adminUrl.trim(), accessToken);
        try {
            com.xxl.job.core.biz.model.ReturnT registryResult = adminBiz.registry(registryParam);
            if (registryResult != null && 200 == registryResult.getCode()) {
                registryResult = com.xxl.job.core.biz.model.ReturnT.SUCCESS;
                this.logger.debug(">>>>>>>>>>> xxl-job registry success, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
            } else {
                this.logger.info(">>>>>>>>>>> xxl-job registry fail, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                Assert.isTrue((boolean)false, (String)">>>>>>>>>>> xxl-job registry fail, registryParam:{}, registryResult:{}", (Object[])new Object[]{registryParam, registryResult});
            }
        }
        catch (Exception e) {
            this.logger.info(">>>>>>>>>>> xxl-job registry error, registryParam:{}", (Object)registryParam, (Object)e);
            Assert.isTrue((boolean)false, (String)">>>>>>>>>>> xxl-job registry error, registryParam:{}", (Object[])new Object[]{registryParam, e});
        }
        return xxlJobSpringExecutor;
    }
}

