/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AlertServer;
import com.machinepublishers.jbrowserdriver.Context;
import com.machinepublishers.jbrowserdriver.ElementRemote;
import com.machinepublishers.jbrowserdriver.ElementServer;
import com.machinepublishers.jbrowserdriver.JBrowserDriverServer;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.TargetLocatorRemote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;

class TargetLocatorServer
extends RemoteObject
implements TargetLocatorRemote,
WebDriver.TargetLocator {
    private final JBrowserDriverServer driver;
    private final Context context;

    TargetLocatorServer(JBrowserDriverServer driver, Context context) throws RemoteException {
        this.driver = driver;
        this.context = context;
    }

    @Override
    public ElementServer activeElement() {
        ElementServer element = (ElementServer)this.driver.executeScript("return document.activeElement;", new Object[0]);
        this.context.item().selectFrame(element);
        return element;
    }

    @Override
    public AlertServer alert() {
        return this.context.alert.get();
    }

    @Override
    public JBrowserDriverServer defaultContent() {
        this.context.item().deselectFrame();
        return this.driver;
    }

    @Override
    public JBrowserDriverServer frame(int index) {
        this.context.item().selectFrame((ElementServer)this.driver.executeScript("return window.frames[arguments[0]].document;", index));
        return this.driver;
    }

    @Override
    public JBrowserDriverServer frame(String nameOrId) {
        List byName = this.driver.findElementsByName(nameOrId);
        List byId = this.driver.findElementsById(nameOrId);
        ArrayList elements = new ArrayList();
        elements.addAll(byName);
        elements.addAll(byId);
        for (ElementServer element : elements) {
            if (!element.getTagName().equals("frame") && !element.getTagName().equals("iframe")) continue;
            element.activate();
            return this.driver;
        }
        return this.driver;
    }

    public JBrowserDriverServer frame(WebElement element) {
        throw new IllegalStateException();
    }

    @Override
    public JBrowserDriverServer frame(ElementRemote element) {
        throw new IllegalStateException();
    }

    @Override
    public JBrowserDriverServer parentFrame() {
        this.context.item().selectFrame((ElementServer)this.driver.executeScript("return window.parent.document;", new Object[0]));
        return this.driver;
    }

    @Override
    public JBrowserDriverServer window(String windowHandle) {
        this.context.setCurrent(windowHandle);
        return this.driver;
    }

    @Override
    public JBrowserDriverServer newWindow(WindowType windowType) {
        this.context.spawn(this.driver);
        return this.driver;
    }
}

