/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.keyvault.CertificateIdentifier;
import com.microsoft.azure.keyvault.KeyIdentifier;
import com.microsoft.azure.keyvault.SecretIdentifier;
import com.microsoft.azure.keyvault.models.CertificateAttributes;
import com.microsoft.azure.keyvault.models.CertificatePolicy;
import com.microsoft.rest.Base64Url;
import java.io.IOException;
import java.util.Map;

public class CertificateBundle {
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="kid", access=JsonProperty.Access.WRITE_ONLY)
    private String kid;
    @JsonProperty(value="sid", access=JsonProperty.Access.WRITE_ONLY)
    private String sid;
    @JsonProperty(value="x5t", access=JsonProperty.Access.WRITE_ONLY)
    private Base64Url x509Thumbprint;
    @JsonProperty(value="policy", access=JsonProperty.Access.WRITE_ONLY)
    private CertificatePolicy policy;
    @JsonProperty(value="cer")
    private byte[] cer;
    @JsonProperty(value="contentType")
    private String contentType;
    @JsonProperty(value="attributes")
    private CertificateAttributes attributes;
    @JsonProperty(value="tags")
    private Map<String, String> tags;

    public String id() {
        return this.id;
    }

    public String kid() {
        return this.kid;
    }

    public String sid() {
        return this.sid;
    }

    public byte[] x509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    public CertificatePolicy policy() {
        return this.policy;
    }

    public byte[] cer() {
        return this.cer;
    }

    public CertificateBundle withCer(byte[] cer) {
        this.cer = cer;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public CertificateBundle withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public CertificateAttributes attributes() {
        return this.attributes;
    }

    public CertificateBundle withAttributes(CertificateAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public CertificateBundle withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public CertificateIdentifier certificateIdentifier() {
        if (this.id() == null || this.id().isEmpty()) {
            return null;
        }
        return new CertificateIdentifier(this.id());
    }

    public SecretIdentifier secretIdentifier() {
        if (this.sid() == null || this.sid().isEmpty()) {
            return null;
        }
        return new SecretIdentifier(this.sid());
    }

    public KeyIdentifier keyIdentifier() {
        if (this.kid() == null || this.kid().isEmpty()) {
            return null;
        }
        return new KeyIdentifier(this.kid());
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

