/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.keyvault.CertificateIdentifier;
import com.microsoft.azure.keyvault.models.CertificateAttributes;
import com.microsoft.rest.Base64Url;
import java.util.Map;

public class CertificateItem {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="attributes")
    private CertificateAttributes attributes;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="x5t")
    private Base64Url x509Thumbprint;

    public String id() {
        return this.id;
    }

    public CertificateItem withId(String id) {
        this.id = id;
        return this;
    }

    public CertificateAttributes attributes() {
        return this.attributes;
    }

    public CertificateItem withAttributes(CertificateAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public CertificateItem withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public byte[] x509Thumbprint() {
        if (this.x509Thumbprint == null) {
            return null;
        }
        return this.x509Thumbprint.decodedBytes();
    }

    public CertificateItem withX509Thumbprint(byte[] x509Thumbprint) {
        this.x509Thumbprint = x509Thumbprint == null ? null : Base64Url.encode((byte[])x509Thumbprint);
        return this;
    }

    public CertificateIdentifier identifier() {
        CertificateIdentifier identifier = null;
        if (this.id() != null && !this.id().isEmpty()) {
            identifier = new CertificateIdentifier(this.id());
        }
        return identifier;
    }
}

