/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.keyvault.CertificateOperationIdentifier;
import com.microsoft.azure.keyvault.models.Error;
import com.microsoft.azure.keyvault.models.IssuerParameters;
import java.io.IOException;

public class CertificateOperation {
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="issuer")
    private IssuerParameters issuerParameters;
    @JsonProperty(value="csr")
    private byte[] csr;
    @JsonProperty(value="cancellation_requested")
    private Boolean cancellationRequested;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="status_details")
    private String statusDetails;
    @JsonProperty(value="error")
    private Error error;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="request_id")
    private String requestId;

    public String id() {
        return this.id;
    }

    public IssuerParameters issuerParameters() {
        return this.issuerParameters;
    }

    public CertificateOperation withIssuerParameters(IssuerParameters issuerParameters) {
        this.issuerParameters = issuerParameters;
        return this;
    }

    public byte[] csr() {
        return this.csr;
    }

    public CertificateOperation withCsr(byte[] csr) {
        this.csr = csr;
        return this;
    }

    public Boolean cancellationRequested() {
        return this.cancellationRequested;
    }

    public CertificateOperation withCancellationRequested(Boolean cancellationRequested) {
        this.cancellationRequested = cancellationRequested;
        return this;
    }

    public String status() {
        return this.status;
    }

    public CertificateOperation withStatus(String status) {
        this.status = status;
        return this;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public CertificateOperation withStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    public Error error() {
        return this.error;
    }

    public CertificateOperation withError(Error error) {
        this.error = error;
        return this;
    }

    public String target() {
        return this.target;
    }

    public CertificateOperation withTarget(String target) {
        this.target = target;
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public CertificateOperation withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public CertificateOperationIdentifier certificateOperationIdentifier() {
        if (this.id() == null || this.id().isEmpty()) {
            return null;
        }
        return new CertificateOperationIdentifier(this.id());
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

