/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.keyvault.IssuerIdentifier;
import com.microsoft.azure.keyvault.models.IssuerAttributes;
import com.microsoft.azure.keyvault.models.IssuerCredentials;
import com.microsoft.azure.keyvault.models.OrganizationDetails;
import java.io.IOException;

public class IssuerBundle {
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="credentials")
    private IssuerCredentials credentials;
    @JsonProperty(value="org_details")
    private OrganizationDetails organizationDetails;
    @JsonProperty(value="attributes")
    private IssuerAttributes attributes;

    public String id() {
        return this.id;
    }

    public String provider() {
        return this.provider;
    }

    public IssuerBundle withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public IssuerCredentials credentials() {
        return this.credentials;
    }

    public IssuerBundle withCredentials(IssuerCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public OrganizationDetails organizationDetails() {
        return this.organizationDetails;
    }

    public IssuerBundle withOrganizationDetails(OrganizationDetails organizationDetails) {
        this.organizationDetails = organizationDetails;
        return this;
    }

    public IssuerAttributes attributes() {
        return this.attributes;
    }

    public IssuerBundle withAttributes(IssuerAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public IssuerIdentifier issuerIdentifier() {
        if (this.id() == null || this.id().isEmpty()) {
            return null;
        }
        return new IssuerIdentifier(this.id());
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonGenerationException e) {
            throw new IllegalStateException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

