/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.CaaRecord;
import com.microsoft.azure.management.dns.CaaRecordSet;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@LangDefinition
class CaaRecordSetImpl
extends DnsRecordSetImpl
implements CaaRecordSet {
    CaaRecordSetImpl(String name, DnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, RecordType.CAA.toString(), parent, innerModel);
    }

    static CaaRecordSetImpl newRecordSet(String name, DnsZoneImpl parent) {
        return new CaaRecordSetImpl(name, parent, new RecordSetInner().withCaaRecords(new ArrayList<CaaRecord>()));
    }

    @Override
    public List<CaaRecord> records() {
        if (((RecordSetInner)this.inner()).caaRecords() != null) {
            return Collections.unmodifiableList(((RecordSetInner)this.inner()).caaRecords());
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)this.inner()).caaRecords() != null && ((RecordSetInner)this.inner()).caaRecords().size() > 0) {
            if (resource.caaRecords() == null) {
                resource.withCaaRecords(new ArrayList<CaaRecord>());
            }
            resource.caaRecords().addAll(((RecordSetInner)this.inner()).caaRecords());
            ((RecordSetInner)this.inner()).caaRecords().clear();
        }
        if (this.recordSetRemoveInfo.caaRecords().size() > 0) {
            if (resource.caaRecords() != null) {
                block0: for (CaaRecord recordToRemove : this.recordSetRemoveInfo.caaRecords()) {
                    for (CaaRecord record : resource.caaRecords()) {
                        if (!record.value().equalsIgnoreCase(recordToRemove.value()) || record.flags().intValue() != recordToRemove.flags().intValue() || !record.tag().equalsIgnoreCase(recordToRemove.tag())) continue;
                        resource.caaRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.caaRecords().clear();
        }
        return resource;
    }
}

