/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.KeyIdentifier;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyItem;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.keyvault.Key;
import com.microsoft.azure.management.keyvault.Keys;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.implementation.KeyImpl;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultFutures;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.concurrent.Future;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class KeysImpl
extends CreatableWrappersImpl<Key, KeyImpl, KeyBundle>
implements Keys {
    private final KeyVaultClient inner;
    private final Vault vault;
    private final Func1<KeyItem, Observable<Key>> converter = new Func1<KeyItem, Observable<Key>>(){

        public Observable<Key> call(final KeyItem keyItem) {
            return new KeyVaultFutures.ServiceFutureConverter<KeyBundle, Key>(){

                @Override
                protected ServiceFuture<KeyBundle> callAsync() {
                    return KeysImpl.this.vault.client().getKeyAsync(keyItem.identifier().identifier(), null);
                }

                @Override
                protected Key wrapModel(KeyBundle keyBundle) {
                    return KeysImpl.this.wrapModel(keyBundle);
                }
            }.toObservable();
        }
    };
    private final PagedListConverter<KeyItem, Key> listConverter = new PagedListConverter<KeyItem, Key>(){

        public Observable<Key> typeConvertAsync(KeyItem inner) {
            return (Observable)KeysImpl.this.converter.call((Object)inner);
        }
    };

    KeysImpl(KeyVaultClient client, Vault vault) {
        this.inner = client;
        this.vault = vault;
    }

    public KeyImpl define(String name) {
        return this.wrapModel(name);
    }

    protected KeyImpl wrapModel(String name) {
        return new KeyImpl(name, new KeyBundle(), this.vault);
    }

    public Key getById(String id) {
        return this.wrapModel(this.inner.getKey(id));
    }

    public Observable<Key> getByIdAsync(String id) {
        return Observable.from(this.getByIdAsync(id, null));
    }

    public ServiceFuture<Key> getByIdAsync(final String id, ServiceCallback<Key> callback) {
        return new KeyVaultFutures.ServiceFutureConverter<KeyBundle, Key>(){

            @Override
            protected ServiceFuture<KeyBundle> callAsync() {
                return KeysImpl.this.inner.getKeyAsync(id, null);
            }

            @Override
            protected Key wrapModel(KeyBundle keyBundle) {
                return KeysImpl.this.wrapModel(keyBundle);
            }
        }.toFuture(callback);
    }

    protected KeyImpl wrapModel(KeyBundle inner) {
        if (inner == null) {
            return null;
        }
        return new KeyImpl(inner.keyIdentifier().name(), inner, this.vault);
    }

    public Completable deleteByIdAsync(String id) {
        KeyIdentifier identifier = new KeyIdentifier(id);
        return Completable.fromFuture((Future)this.inner.deleteKeyAsync(identifier.vault(), identifier.name(), null));
    }

    public PagedList<Key> list() {
        return this.listConverter.convert(this.inner.listKeys(this.vault.vaultUri()));
    }

    public Observable<Key> listAsync() {
        return new KeyVaultFutures.ListCallbackObserver<KeyItem, Key>(){

            @Override
            protected void list(ListOperationCallback<KeyItem> callback) {
                KeysImpl.this.inner.listKeysAsync(KeysImpl.this.vault.vaultUri(), callback);
            }

            @Override
            protected Observable<Key> typeConvertAsync(KeyItem keyItem) {
                return (Observable)KeysImpl.this.converter.call((Object)keyItem);
            }
        }.toObservable();
    }

    @Override
    public Key restore(byte[] backup) {
        return this.wrapModel(this.vault.client().restoreKey(this.vault.vaultUri(), backup));
    }

    @Override
    public Observable<Key> restoreAsync(final byte[] backup) {
        return new KeyVaultFutures.ServiceFutureConverter<KeyBundle, Key>(){

            @Override
            protected ServiceFuture<KeyBundle> callAsync() {
                return KeysImpl.this.vault.client().restoreKeyAsync(KeysImpl.this.vault.vaultUri(), backup, null);
            }

            @Override
            protected Key wrapModel(KeyBundle keyBundle) {
                return KeysImpl.this.wrapModel(keyBundle);
            }
        }.toObservable();
    }
}

