/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.request;

import com.mzlion.core.io.IOUtils;
import com.mzlion.core.json.TypeRef;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.CollectionUtils;
import com.mzlion.core.lang.StringUtils;
import com.mzlion.easyokhttp.HttpClient;
import com.mzlion.easyokhttp.exception.HttpClientConfigException;
import com.mzlion.easyokhttp.exception.HttpClientException;
import com.mzlion.easyokhttp.exception.HttpStatusCodeException;
import com.mzlion.easyokhttp.http.ProcessRequestBody;
import com.mzlion.easyokhttp.request.HttpRequest;
import com.mzlion.easyokhttp.response.HttpResponse;
import com.mzlion.easyokhttp.response.callback.Callback;
import com.mzlion.easyokhttp.utils.SSLContexts;
import com.mzlion.easyokhttp.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsHttpRequest<Req extends HttpRequest<Req>>
implements HttpRequest<Req> {
    protected Logger logger = LoggerFactory.getLogger(AbsHttpRequest.class);
    protected String url;
    private TimeoutHolder connectTimeout;
    private TimeoutHolder readTimeout;
    private TimeoutHolder writeTimeout;
    private CertificateHolder certificateHolder = null;
    private Map<String, String> headers;
    private Map<String, List<String>> queryParams;

    AbsHttpRequest(String url) {
        this.url = url;
        this.headers = new LinkedHashMap<String, String>();
        this.queryParams = new LinkedHashMap<String, List<String>>();
        this.header("Accept-Language", Utils.getAcceptLanguage());
        this.header("User-Agent", Utils.getUserAgent());
    }

    @Override
    public Req url(String url) {
        this.url = url;
        return (Req)this;
    }

    @Override
    public Req queryString(String name, Number value) {
        return this.queryString(name, value == null ? null : value.toString());
    }

    @Override
    public Req queryString(String name, String value) {
        return this.queryString(name, value, false);
    }

    @Override
    public Req queryString(String name, String value, boolean replace) {
        if (StringUtils.isEmpty((String)name)) {
            return (Req)this;
        }
        if (!replace && value == null) {
            this.logger.warn(" ===> The value is null,ignore:name={},value=null", (Object)name);
            return (Req)this;
        }
        List<String> valueList = this.queryParams.get(name);
        if (valueList == null) {
            valueList = new LinkedList<String>();
            this.queryParams.put(name, valueList);
        }
        if (replace) {
            valueList.clear();
        }
        valueList.add(value);
        return (Req)this;
    }

    @Override
    public Req queryString(Map<String, String> parameters) {
        if (CollectionUtils.isEmpty(parameters)) {
            return (Req)this;
        }
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.queryString(entry.getKey(), entry.getValue());
        }
        return (Req)this;
    }

    @Override
    public Req header(String name, String value) {
        if (StringUtils.hasLength((String)name) && null != value) {
            this.headers.put(name, value);
        }
        return (Req)this;
    }

    @Override
    public Req removeHeader(String name) {
        if (StringUtils.hasLength((String)name)) {
            this.headers.remove(name);
        }
        return (Req)this;
    }

    @Override
    public Req connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        if (connectTimeout < 0) {
            throw new HttpClientConfigException("Connect Timeout may be than 0.");
        }
        if (timeUnit == null) {
            throw new HttpClientConfigException("TimeUnit may not be null.");
        }
        this.connectTimeout = new TimeoutHolder(connectTimeout, timeUnit);
        return (Req)this;
    }

    @Override
    public Req connectTimeout(int connectTimeout) {
        return this.connectTimeout(connectTimeout, TimeUnit.SECONDS);
    }

    @Override
    public Req readTimeout(int readTimeout, TimeUnit timeUnit) {
        if (readTimeout < 0) {
            throw new HttpClientConfigException("Read Timeout may be than 0.");
        }
        if (timeUnit == null) {
            throw new HttpClientConfigException("TimeUnit may not be null.");
        }
        this.readTimeout = new TimeoutHolder(readTimeout, timeUnit);
        return (Req)this;
    }

    @Override
    public Req readTimeout(int readTimeout) {
        return this.readTimeout(readTimeout, TimeUnit.SECONDS);
    }

    @Override
    public Req writeTimeout(int writeTimeout, TimeUnit timeUnit) {
        if (writeTimeout < 0) {
            throw new HttpClientConfigException("Write Timeout may be than 0.");
        }
        if (timeUnit == null) {
            throw new HttpClientConfigException("TimeUnit may not be null.");
        }
        this.writeTimeout = new TimeoutHolder(writeTimeout, timeUnit);
        return (Req)this;
    }

    @Override
    public Req writeTimeout(int writeTimeout) {
        return this.writeTimeout(writeTimeout, TimeUnit.SECONDS);
    }

    @Override
    public Req customSSL(InputStream ... certificates) {
        return this.customSSL((InputStream)null, (char[])null, certificates);
    }

    @Override
    public Req customSSL(X509TrustManager trustManager) {
        return this.customSSL(null, null, trustManager);
    }

    @Override
    public Req customSSL(InputStream pfxStream, char[] pfxPwd, InputStream ... certificates) {
        this.certificateHolder = new CertificateHolder(certificates, null, pfxStream, pfxPwd);
        return (Req)this;
    }

    @Override
    public Req customSSL(InputStream pfxStream, char[] pfxPwd, X509TrustManager trustManager) {
        this.certificateHolder = new CertificateHolder(null, trustManager, pfxStream, pfxPwd);
        return (Req)this;
    }

    public String asString() {
        return this.execute().asString();
    }

    public <E> E asBean(Class<E> targetClass) {
        return this.execute().asBean(targetClass);
    }

    public <E> E asBean(TypeRef<E> typeRef) {
        return this.execute().asBean(typeRef);
    }

    public byte[] asByteData() {
        return this.execute().asByteData();
    }

    public void asFile(File saveFile) {
        this.execute().asFile(saveFile);
    }

    public void asStream(OutputStream out) {
        this.execute().asStream(out);
    }

    @Override
    public HttpResponse execute() {
        RequestBody requestBody = this.generateRequestBody();
        Request request = this.generateRequest(requestBody);
        Call call = this.generateCall(request);
        Response response = null;
        try {
            response = call.execute();
            ResponseBody responseBody = response.body();
            byte[] byteData = responseBody.bytes();
            Response newResponse = response.newBuilder().body(ResponseBody.create((MediaType)responseBody.contentType(), (byte[])byteData)).build();
            HttpResponse httpResponse = new HttpResponse(newResponse);
            httpResponse.setErrorMessage(response.message());
            httpResponse.setHttpCode(response.code());
            if (response.code() < 200 || response.code() >= 300) {
                httpResponse.setSuccess(false);
                HttpResponse httpResponse2 = httpResponse;
                return httpResponse2;
            }
            httpResponse.setSuccess(true);
            HttpResponse httpResponse3 = httpResponse;
            return httpResponse3;
        }
        catch (IOException e) {
            throw new HttpClientException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
    }

    @Override
    public <T> void execute(Callback<T> callback) {
        Callback _cb = callback;
        if (_cb == null) {
            _cb = Callback.EMPTY_CALLBACK;
        }
        if (!callback.onBefore(this)) {
            return;
        }
        final Callback finalCb = _cb;
        ProcessRequestBody processRequestBody = new ProcessRequestBody(this.generateRequestBody(), new ProcessRequestBody.Listener(){

            @Override
            public void onRequestProgress(long bytesWritten, long contentLength) {
                finalCb.postProgress(bytesWritten, contentLength, 1.0f * (float)bytesWritten / (float)contentLength);
            }
        });
        Call call = this.generateCall(this.generateRequest(processRequestBody));
        call.enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                finalCb.onError(call, e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                finalCb.onComplete(response);
                if (response.code() >= 200 && response.code() < 300) {
                    try {
                        finalCb.onSuccess(finalCb.getDataHandler() == null ? null : (Object)finalCb.getDataHandler().handle(response));
                    }
                    finally {
                        response.close();
                    }
                } else {
                    finalCb.onError(call, new HttpStatusCodeException(AbsHttpRequest.this.url, response.code(), response.message()));
                }
            }
        });
    }

    protected abstract RequestBody generateRequestBody();

    protected abstract Request generateRequest(RequestBody var1);

    private Call generateCall(Request request) {
        if (this.readTimeout == null && this.connectTimeout == null && this.writeTimeout == null && this.certificateHolder == null) {
            return HttpClient.Instance.getOkHttpClient().newCall(request);
        }
        OkHttpClient.Builder builder = HttpClient.Instance.getOkHttpClientBuilder();
        if (this.connectTimeout != null) {
            builder.connectTimeout((long)this.connectTimeout.timeout, this.connectTimeout.timeUnit);
        }
        if (this.readTimeout != null) {
            builder.readTimeout((long)this.readTimeout.timeout, this.readTimeout.timeUnit);
        }
        if (this.writeTimeout != null) {
            builder.writeTimeout((long)this.writeTimeout.timeout, this.writeTimeout.timeUnit);
        }
        if (this.certificateHolder != null) {
            SSLContexts.SSLConfig sslConfig = SSLContexts.tryParse(this.certificateHolder.certificates, this.certificateHolder.trustManager, this.certificateHolder.pfxStream, this.certificateHolder.pfxPwd);
            builder.sslSocketFactory(sslConfig.getSslSocketFactory(), sslConfig.getX509TrustManager());
        }
        return builder.build().newCall(request);
    }

    void collectHeader(Request.Builder builder, HttpUrl httpUrl) {
        Map<String, String> defaultHeaders = HttpClient.Instance.getDefaultHeaders(httpUrl);
        if (CollectionUtils.isNotEmpty(defaultHeaders)) {
            for (Map.Entry<String, String> entry : defaultHeaders.entrySet()) {
                builder.header(entry.getKey(), entry.getValue());
            }
        }
        if (CollectionUtils.isNotEmpty(this.headers)) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                builder.header(entry.getKey(), entry.getValue());
            }
        }
    }

    String buildUrl() {
        Assert.hasLength((String)this.url, (String)"Url must not be null.");
        StringBuilder sb = new StringBuilder(this.url);
        if (this.url.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        if (CollectionUtils.isNotEmpty(this.queryParams)) {
            for (Map.Entry<String, List<String>> entry : this.queryParams.entrySet()) {
                for (String value : entry.getValue()) {
                    sb.append(entry.getKey()).append("=").append(Utils.urlEncode(value)).append("&");
                }
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    final class TimeoutHolder {
        int timeout;
        TimeUnit timeUnit;

        TimeoutHolder(int timeout, TimeUnit timeUnit) {
            this.timeout = timeout;
            this.timeUnit = timeUnit;
        }
    }

    final class CertificateHolder {
        InputStream[] certificates;
        X509TrustManager trustManager;
        InputStream pfxStream;
        char[] pfxPwd;

        CertificateHolder(InputStream[] certificates, X509TrustManager trustManager, InputStream pfxStream, char[] pfxPwd) {
            this.certificates = certificates;
            this.trustManager = trustManager;
            this.pfxStream = pfxStream;
            this.pfxPwd = pfxPwd;
        }
    }
}

