/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.request;

import com.mzlion.core.lang.CollectionUtils;
import com.mzlion.core.lang.StringUtils;
import com.mzlion.easyokhttp.http.FileWrapper;
import com.mzlion.easyokhttp.request.BaseBodyHttpRequest;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class PostRequest
extends BaseBodyHttpRequest<PostRequest> {
    private boolean isMultipart;
    private Map<String, List<String>> formParams = new LinkedHashMap<String, List<String>>();
    private Map<String, List<FileWrapper>> fileParams = new LinkedHashMap<String, List<FileWrapper>>();

    public PostRequest(String url) {
        super(url);
    }

    @Override
    protected RequestBody generateRequestBody() {
        if (CollectionUtils.isEmpty(this.fileParams) && !this.isMultipart) {
            FormBody.Builder builder = new FormBody.Builder();
            if (CollectionUtils.isNotEmpty(this.formParams)) {
                for (Map.Entry<String, List<String>> entry : this.formParams.entrySet()) {
                    for (String string : entry.getValue()) {
                        builder.add(entry.getKey(), string);
                    }
                }
            }
            return builder.build();
        }
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        if (CollectionUtils.isNotEmpty(this.formParams)) {
            for (Map.Entry<String, List<String>> entry : this.formParams.entrySet()) {
                for (String string : entry.getValue()) {
                    builder.addFormDataPart(entry.getKey(), string);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(this.fileParams)) {
            for (Map.Entry<String, List<Object>> entry : this.fileParams.entrySet()) {
                for (FileWrapper fileWrapper : entry.getValue()) {
                    builder.addFormDataPart(entry.getKey(), fileWrapper.getFilename(), fileWrapper.requestBody());
                }
            }
        }
        return builder.build();
    }

    public PostRequest isMultipart(boolean isMultipart) {
        this.isMultipart = isMultipart;
        return this;
    }

    public PostRequest param(String name, String value) {
        return this.param(name, value, false);
    }

    public PostRequest param(String name, String value, boolean replace) {
        if (StringUtils.isEmpty((String)name)) {
            this.logger.debug(" ===> The parameter[name] is null or empty.");
            return this;
        }
        if (!replace && value == null) {
            this.logger.warn(" ===> The value is null,ignore:name={},value=null", (Object)name);
            return this;
        }
        List<String> valueList = this.formParams.get(name);
        if (valueList == null) {
            valueList = new LinkedList<String>();
            this.formParams.put(name, valueList);
        }
        if (replace) {
            valueList.clear();
        }
        valueList.add(value);
        return this;
    }

    public PostRequest param(Map<String, String> parameters) {
        if (CollectionUtils.isEmpty(parameters)) {
            this.logger.debug(" ===> The parameter[parameters] is null or empty.");
            return this;
        }
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.param(entry.getKey(), entry.getValue(), false);
        }
        return this;
    }

    public PostRequest param(String name, File uploadFile) {
        return this.param(name, uploadFile, uploadFile.getName());
    }

    public PostRequest param(String name, File uploadFile, String filename) {
        if (StringUtils.isEmpty((String)name)) {
            this.logger.debug(" ===> The parameter[name] is null or empty.");
            return this;
        }
        if (uploadFile == null) {
            this.logger.warn(" ===> The parameter[uploadFile] is null,ignore:name={}.", (Object)name);
            return this;
        }
        if (StringUtils.isEmpty((String)filename)) {
            this.logger.warn(" ===> The parameter[filename] is null,ignore:name={},uploadFile={}.", (Object)name, (Object)uploadFile);
            return this;
        }
        List<FileWrapper> fileWrapperList = this.fileParams.get(name);
        if (fileWrapperList == null) {
            fileWrapperList = new LinkedList<FileWrapper>();
            this.fileParams.put(name, fileWrapperList);
        }
        fileWrapperList.add(FileWrapper.create().file(uploadFile).filename(filename).build());
        return this;
    }

    public PostRequest param(String name, InputStream inputStream, String streamName) {
        if (StringUtils.isEmpty((String)name)) {
            this.logger.debug(" ===> The parameter[name] is null or empty.");
            return this;
        }
        if (inputStream == null) {
            this.logger.warn(" ===> The parameter[inputStream] is null,ignore:name={}.", (Object)name);
            return this;
        }
        if (StringUtils.isEmpty((String)streamName)) {
            this.logger.warn(" ===> The parameter[streamName] is null,ignore:name={},inputStream={}.", (Object)name, (Object)inputStream);
            return this;
        }
        List<FileWrapper> fileWrapperList = this.fileParams.get(name);
        if (fileWrapperList == null) {
            fileWrapperList = new LinkedList<FileWrapper>();
            this.fileParams.put(name, fileWrapperList);
        }
        fileWrapperList.add(FileWrapper.create().stream(inputStream).filename(streamName).build());
        return this;
    }
}

