/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.response.handle;

import com.mzlion.core.io.FileUtils;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.lang.StringUtils;
import com.mzlion.easyokhttp.response.handle.DataHandler;
import com.mzlion.easyokhttp.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;

public class FileDataHandler
implements DataHandler<File> {
    private final String dirPath;
    private String filename;

    public FileDataHandler(String dirPath) {
        Assert.notNull((Object)dirPath, (String)"DirPath may not be null.");
        this.dirPath = dirPath;
    }

    public FileDataHandler(String dirPath, String filename) {
        this(dirPath);
        this.filename = filename;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public File handle(Response response) throws IOException {
        String name = this.filename;
        if (StringUtils.isEmpty((String)name)) {
            name = Utils.getFilename(response);
        }
        File saveFile = new File(this.dirPath, name);
        FileUtils.copyStream((InputStream)response.body().byteStream(), (File)saveFile);
        return saveFile;
    }
}

