/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.nacos.adapter;

import com.alibaba.nacos.api.config.listener.Listener;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.nacos.operation.NacosOperation;
import com.nepxion.discovery.common.nacos.operation.NacosSubscribeCallback;
import com.nepxion.discovery.common.thread.NamedThreadFactory;
import com.nepxion.discovery.plugin.configcenter.adapter.ConfigAdapter;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.event.RuleClearedEvent;
import com.nepxion.discovery.plugin.framework.event.RuleUpdatedEvent;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NacosConfigAdapter
extends ConfigAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(NacosConfigAdapter.class);
    private ExecutorService executorService = new ThreadPoolExecutor(2, 4, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("nacos-config"), new ThreadPoolExecutor.DiscardOldestPolicy());
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private NacosOperation nacosOperation;
    private Listener partialListener;
    private Listener globalListener;

    public String getConfig() throws Exception {
        String config = this.getConfig(false);
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            LOG.info("Found {} config from {} server", (Object)this.getConfigScope(false), (Object)this.getConfigType());
            return config;
        }
        LOG.info("No {} config is found from {} server", (Object)this.getConfigScope(false), (Object)this.getConfigType());
        config = this.getConfig(true);
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            LOG.info("Found {} config from {} server", (Object)this.getConfigScope(true), (Object)this.getConfigType());
            return config;
        }
        LOG.info("No {} config is found from {} server", (Object)this.getConfigScope(true), (Object)this.getConfigType());
        return null;
    }

    private String getConfig(boolean globalConfig) throws Exception {
        String group = this.pluginAdapter.getGroup();
        String serviceId = this.pluginAdapter.getServiceId();
        return this.nacosOperation.getConfig(group, globalConfig ? group : serviceId);
    }

    @PostConstruct
    public void subscribeConfig() {
        this.partialListener = this.subscribeConfig(false);
        this.globalListener = this.subscribeConfig(true);
    }

    private Listener subscribeConfig(final boolean globalConfig) {
        final String groupKey = this.pluginAdapter.getGroupKey();
        final String group = this.pluginAdapter.getGroup();
        final String serviceId = this.pluginAdapter.getServiceId();
        LOG.info("Subscribe {} config from {} server, {}={}, serviceId={}", new Object[]{this.getConfigScope(globalConfig), this.getConfigType(), groupKey, group, serviceId});
        try {
            return this.nacosOperation.subscribeConfig(group, globalConfig ? group : serviceId, (Executor)this.executorService, new NacosSubscribeCallback(){

                public void callback(String config) {
                    if (StringUtils.isNotEmpty((CharSequence)config)) {
                        LOG.info("Get {} config updated event from {} server, {}={}, serviceId={}", new Object[]{NacosConfigAdapter.this.getConfigScope(globalConfig), NacosConfigAdapter.this.getConfigType(), groupKey, group, serviceId});
                        RuleEntity ruleEntity = NacosConfigAdapter.this.pluginAdapter.getRule();
                        String rule = null;
                        if (ruleEntity != null) {
                            rule = ruleEntity.getContent();
                        }
                        if (!StringUtils.equals((CharSequence)rule, (CharSequence)config)) {
                            NacosConfigAdapter.this.fireRuleUpdated(new RuleUpdatedEvent(config), true);
                        } else {
                            LOG.info("Updated {} config from {} server is same as current config, ignore to update, {}={}, serviceId={}", new Object[]{NacosConfigAdapter.this.getConfigScope(globalConfig), NacosConfigAdapter.this.getConfigType(), groupKey, group, serviceId});
                        }
                    } else {
                        LOG.info("Get {} config cleared event from {} server, {}={}, serviceId={}", new Object[]{NacosConfigAdapter.this.getConfigScope(globalConfig), NacosConfigAdapter.this.getConfigType(), groupKey, group, serviceId});
                        NacosConfigAdapter.this.fireRuleCleared(new RuleClearedEvent(), true);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Subscribe {} config from {} server failed, {}={}, serviceId={}", new Object[]{this.getConfigScope(globalConfig), this.getConfigType(), groupKey, group, serviceId, e});
            return null;
        }
    }

    public void close() {
        this.unsubscribeConfig(this.partialListener, false);
        this.unsubscribeConfig(this.globalListener, true);
        this.executorService.shutdownNow();
    }

    private void unsubscribeConfig(Listener configListener, boolean globalConfig) {
        if (configListener == null) {
            return;
        }
        String groupKey = this.pluginAdapter.getGroupKey();
        String group = this.pluginAdapter.getGroup();
        String serviceId = this.pluginAdapter.getServiceId();
        LOG.info("Unsubscribe {} config from {} server, {}={}, serviceId={}", new Object[]{this.getConfigScope(globalConfig), this.getConfigType(), groupKey, group, serviceId});
        this.nacosOperation.unsubscribeConfig(group, globalConfig ? group : serviceId, configListener);
    }

    public String getConfigScope(boolean globalConfig) {
        return globalConfig ? "global" : "partial";
    }

    public String getConfigType() {
        return "Nacos";
    }
}

