/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.configuration;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.ribbon.NacosRibbonClientConfiguration;
import com.nepxion.discovery.plugin.framework.decorator.NacosServerListDecorator;
import com.nepxion.discovery.plugin.framework.listener.loadbalance.LoadBalanceListenerExecutor;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ServerList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@AutoConfigureAfter(value={NacosRibbonClientConfiguration.class})
public class NacosLoadBalanceConfiguration {
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private LoadBalanceListenerExecutor loadBalanceListenerExecutor;

    @Bean
    public ServerList<?> ribbonServerList(IClientConfig config, NacosDiscoveryProperties nacosDiscoveryProperties) {
        NacosServerListDecorator serverList = new NacosServerListDecorator(nacosDiscoveryProperties);
        serverList.initWithNiwsConfig(config);
        serverList.setEnvironment(this.environment);
        serverList.setLoadBalanceListenerExecutor(this.loadBalanceListenerExecutor);
        return serverList;
    }
}

