/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.context;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.nepxion.discovery.plugin.framework.adapter.ApplicationInfoAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginApplicationContextInitializer;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.decorator.NacosServiceRegistryDecorator;
import com.nepxion.discovery.plugin.framework.util.MetadataUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.SpringBootVersion;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class NacosApplicationContextInitializer
extends PluginApplicationContextInitializer {
    protected Object afterInitialization(ConfigurableApplicationContext applicationContext, Object bean, String beanName) throws BeansException {
        if (bean instanceof NacosServiceRegistry) {
            NacosServiceRegistry nacosServiceRegistry = (NacosServiceRegistry)bean;
            NacosDiscoveryProperties nacosDiscoveryProperties = (NacosDiscoveryProperties)applicationContext.getBean(NacosDiscoveryProperties.class);
            return new NacosServiceRegistryDecorator(nacosDiscoveryProperties, nacosServiceRegistry, applicationContext);
        }
        if (bean instanceof NacosDiscoveryProperties) {
            String gitVersion;
            String prefixGroup;
            String groupKey;
            ConfigurableEnvironment environment = applicationContext.getEnvironment();
            NacosDiscoveryProperties nacosDiscoveryProperties = (NacosDiscoveryProperties)bean;
            Map metadata = nacosDiscoveryProperties.getMetadata();
            if (!metadata.containsKey(groupKey = PluginContextAware.getGroupKey((Environment)environment))) {
                metadata.put(groupKey, "default");
            }
            if (!metadata.containsKey("version")) {
                metadata.put("version", "default");
            }
            if (!metadata.containsKey("region")) {
                metadata.put("region", "default");
            }
            if (StringUtils.isNotEmpty((CharSequence)(prefixGroup = this.getPrefixGroup(applicationContext)))) {
                metadata.put(groupKey, prefixGroup);
            }
            if (StringUtils.isNotEmpty((CharSequence)(gitVersion = this.getGitVersion(applicationContext)))) {
                metadata.put("version", gitVersion);
            }
            metadata.put("spring.boot.version", SpringBootVersion.getVersion());
            metadata.put("spring.application.name", PluginContextAware.getApplicationName((Environment)environment));
            metadata.put("spring.application.type", PluginContextAware.getApplicationType((Environment)environment));
            metadata.put("spring.application.discovery.plugin", "Nacos");
            metadata.put("spring.application.discovery.version", "6.0.7");
            String agentVersion = System.getProperty("spring.application.discovery.agent.version");
            metadata.put("spring.application.discovery.agent.version", StringUtils.isEmpty((CharSequence)agentVersion) ? "unknown" : agentVersion);
            metadata.put("spring.application.register.control.enabled", PluginContextAware.isRegisterControlEnabled((Environment)environment).toString());
            metadata.put("spring.application.discovery.control.enabled", PluginContextAware.isDiscoveryControlEnabled((Environment)environment).toString());
            metadata.put("spring.application.config.rest.control.enabled", PluginContextAware.isConfigRestControlEnabled((Environment)environment).toString());
            metadata.put("spring.application.group.key", groupKey);
            metadata.put("spring.application.context-path", PluginContextAware.getContextPath((Environment)environment));
            try {
                ApplicationInfoAdapter applicationInfoAdapter = (ApplicationInfoAdapter)applicationContext.getBean(ApplicationInfoAdapter.class);
                if (applicationInfoAdapter != null) {
                    metadata.put("app.id", applicationInfoAdapter.getAppId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            MetadataUtil.filter((Map)metadata);
            return bean;
        }
        return bean;
    }
}

