/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.decorator;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.ribbon.NacosServer;
import com.alibaba.cloud.nacos.ribbon.NacosServerList;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.listener.loadbalance.LoadBalanceListenerExecutor;
import java.util.List;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class NacosServerListDecorator
extends NacosServerList {
    private ConfigurableEnvironment environment;
    private LoadBalanceListenerExecutor loadBalanceListenerExecutor;

    public NacosServerListDecorator(NacosDiscoveryProperties discoveryProperties) {
        super(discoveryProperties);
    }

    public List<NacosServer> getInitialListOfServers() {
        List servers = super.getInitialListOfServers();
        this.filter(servers);
        return servers;
    }

    public List<NacosServer> getUpdatedListOfServers() {
        List servers = super.getUpdatedListOfServers();
        this.filter(servers);
        return servers;
    }

    private void filter(List<NacosServer> servers) {
        Boolean discoveryControlEnabled = PluginContextAware.isDiscoveryControlEnabled((Environment)this.environment);
        if (discoveryControlEnabled.booleanValue()) {
            String serviceId = this.getServiceId();
            this.loadBalanceListenerExecutor.onGetServers(serviceId, servers);
        }
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void setLoadBalanceListenerExecutor(LoadBalanceListenerExecutor loadBalanceListenerExecutor) {
        this.loadBalanceListenerExecutor = loadBalanceListenerExecutor;
    }
}

