/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.opentracing.monitor;

import com.nepxion.discovery.plugin.strategy.monitor.AbstractStrategyTracer;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StrategyOpentracingTracer
extends AbstractStrategyTracer<Span> {
    @Value(value="${spring.application.strategy.tracer.exception.detail.output.enabled:false}")
    protected Boolean tracerExceptionDetailOutputEnabled;
    @Autowired
    private Tracer tracer;

    protected Span buildSpan() {
        return this.tracer.buildSpan(this.tracerSpanValue).start();
    }

    protected void outputSpan(Span span, String key, String value) {
        span.setTag(key, value);
    }

    protected void errorSpan(Span span, Throwable e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", Tags.ERROR.getKey());
        if (this.tracerExceptionDetailOutputEnabled.booleanValue()) {
            map.put("error.object", ExceptionUtils.getStackTrace((Throwable)e));
        } else {
            map.put("error.object", e);
        }
        span.log(map);
    }

    protected void finishSpan(Span span) {
        span.finish();
    }

    protected Span getActiveSpan() {
        return this.tracer.activeSpan();
    }

    protected String toTraceId(Span span) {
        return span.context().toTraceId();
    }

    protected String toSpanId(Span span) {
        return span.context().toSpanId();
    }
}

