/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.converters.Converters;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;

public class JsonXStream
extends XStream {
    private static final JsonXStream s_instance = new JsonXStream();

    public JsonXStream() {
        super((HierarchicalStreamDriver)new JettisonMappedXmlDriver(){
            private final NameCoder coder = JsonXStream.access$000();

            protected NameCoder getNameCoder() {
                return this.coder;
            }
        });
        this.registerConverter(new Converters.ApplicationConverter());
        this.registerConverter(new Converters.ApplicationsConverter());
        this.registerConverter(new Converters.DataCenterInfoConverter());
        this.registerConverter(new Converters.InstanceInfoConverter());
        this.registerConverter(new Converters.LeaseInfoConverter());
        this.registerConverter(new Converters.MetadataConverter());
        this.setMode(1001);
        this.processAnnotations(new Class[]{InstanceInfo.class, Application.class, Applications.class});
    }

    public static JsonXStream getInstance() {
        return s_instance;
    }

    private static XmlFriendlyNameCoder initializeNameCoder() {
        EurekaClientConfig clientConfig = DiscoveryManager.getInstance().getEurekaClientConfig();
        if (clientConfig == null) {
            return new XmlFriendlyNameCoder();
        }
        return new XmlFriendlyNameCoder(clientConfig.getDollarReplacement(), clientConfig.getEscapeCharReplacement());
    }

    static /* synthetic */ XmlFriendlyNameCoder access$000() {
        return JsonXStream.initializeNameCoder();
    }
}

