/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;

public class DefaultEurekaTransportConfig
implements EurekaTransportConfig {
    private static final String SUB_NAMESPACE = "transport.";
    private final String namespace;
    private final DynamicPropertyFactory configInstance;

    public DefaultEurekaTransportConfig(String parentNamespace, DynamicPropertyFactory configInstance) {
        this.namespace = parentNamespace == null ? SUB_NAMESPACE : parentNamespace + SUB_NAMESPACE;
        this.configInstance = configInstance;
    }

    @Override
    public int getSessionedClientReconnectIntervalSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "sessionedClientReconnectIntervalSeconds", 1200).get();
    }

    @Override
    public double getRetryableClientQuarantineRefreshPercentage() {
        return this.configInstance.getDoubleProperty(this.namespace + "retryableClientQuarantineRefreshPercentage", 0.66).get();
    }

    @Override
    public int getApplicationsResolverDataStalenessThresholdSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "applicationsResolverDataStalenessThresholdSeconds", 300).get();
    }

    @Override
    public boolean applicationsResolverUseIp() {
        return this.configInstance.getBooleanProperty(this.namespace + "applicationsResolverUseIp", false).get();
    }

    @Override
    public int getAsyncResolverRefreshIntervalMs() {
        return this.configInstance.getIntProperty(this.namespace + "asyncResolverRefreshIntervalMs", 300000).get();
    }

    @Override
    public int getAsyncResolverWarmUpTimeoutMs() {
        return this.configInstance.getIntProperty(this.namespace + "asyncResolverWarmupTimeoutMs", 5000).get();
    }

    @Override
    public int getAsyncExecutorThreadPoolSize() {
        return this.configInstance.getIntProperty(this.namespace + "asyncExecutorThreadPoolSize", 5).get();
    }

    @Override
    public String getWriteClusterVip() {
        return this.configInstance.getStringProperty(this.namespace + "writeClusterVip", null).get();
    }

    @Override
    public String getReadClusterVip() {
        return this.configInstance.getStringProperty(this.namespace + "readClusterVip", null).get();
    }

    @Override
    public String getBootstrapResolverStrategy() {
        return this.configInstance.getStringProperty(this.namespace + "bootstrapResolverStrategy", null).get();
    }

    @Override
    public boolean useBootstrapResolverForQuery() {
        return this.configInstance.getBooleanProperty(this.namespace + "useBootstrapResolverForQuery", true).get();
    }
}

