/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.sample.stream;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.hystrix.contrib.sample.stream.HystrixSampleSseServlet;
import com.netflix.hystrix.contrib.sample.stream.HystrixUtilizationJsonStream;
import com.netflix.hystrix.metric.sample.HystrixUtilization;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.functions.Func1;

public class HystrixUtilizationSseServlet
extends HystrixSampleSseServlet<HystrixUtilization> {
    private static final long serialVersionUID = -7812908330777694972L;
    private static final int DEFAULT_ONNEXT_DELAY_IN_MS = 100;
    private final HystrixUtilizationJsonStream jsonStream;
    private static AtomicInteger concurrentConnections = new AtomicInteger(0);
    private static DynamicIntProperty maxConcurrentConnections = DynamicPropertyFactory.getInstance().getIntProperty("hystrix.config.stream.maxConcurrentConnections", 5);

    public HystrixUtilizationSseServlet() {
        this.jsonStream = new HystrixUtilizationJsonStream();
    }

    HystrixUtilizationSseServlet(Func1<Integer, Observable<HystrixUtilization>> createStream) {
        this.jsonStream = new HystrixUtilizationJsonStream(createStream);
    }

    @Override
    int getDefaultDelayInMilliseconds() {
        return 100;
    }

    @Override
    int getMaxNumberConcurrentConnectionsAllowed() {
        return maxConcurrentConnections.get();
    }

    @Override
    int getNumberCurrentConnections() {
        return concurrentConnections.get();
    }

    @Override
    protected int incrementAndGetCurrentConcurrentConnections() {
        return concurrentConnections.incrementAndGet();
    }

    @Override
    protected void decrementCurrentConcurrentConnections() {
        concurrentConnections.decrementAndGet();
    }

    @Override
    protected Observable<HystrixUtilization> getStream(int delay) {
        return this.jsonStream.observe(delay);
    }

    @Override
    protected String convertToString(HystrixUtilization utilization) throws IOException {
        return HystrixUtilizationJsonStream.convertToJson(utilization);
    }
}

