/**
 * Javascript Object Signing and Encryption (JOSE) classes.
 *
 * <p>This package provides representation, compact serialisation and parsing 
 * for the following JOSE objects:
 *
 * <ul>
 *     <li>{@link com.nimbusds.jose.PlainObject Unsecured ({@code alg=none})
 *         JOSE objects}.
 *     <li>{@link com.nimbusds.jose.JWSObject JSON Web Signature (JWS) 
 *         objects}.
 *     <li>{@link com.nimbusds.jose.JWEObject JSON Web Encryption (JWE) 
 *         objects}.
 * </ul>
 *
 * <p>References:
 *
 * <ul>
 *     <li><a href="http://tools.ietf.org/html/rfc7515">RFC 7515 (JWS)</a>
 *     <li><a href="http://tools.ietf.org/html/rfc7516">RFC 7516 (JWE)</a>
 * </ul>
 */
package com.nimbusds.jose;
