/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.common.packet;

import java.util.HashMap;
import java.util.Map;

public enum LogType {
    OCEANBASE(0);

    private final int code;
    private static final Map<Integer, LogType> CODE_TYPES;

    private LogType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static LogType fromString(String string) {
        if (string == null) {
            throw new NullPointerException("logTypeString is null");
        }
        return LogType.valueOf(string.toUpperCase());
    }

    public static LogType fromCode(int code) {
        if (CODE_TYPES.containsKey(code)) {
            return CODE_TYPES.get(code);
        }
        return null;
    }

    static {
        CODE_TYPES = new HashMap<Integer, LogType>(LogType.values().length);
        for (LogType logCaptureType : LogType.values()) {
            CODE_TYPES.put(logCaptureType.code, logCaptureType);
        }
    }
}

