/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;

public class Decoder {
    public static String decodeStringInt(ByteBuf buffer) {
        if (buffer.readableBytes() < 4) {
            return null;
        }
        buffer.markReaderIndex();
        int length = buffer.readInt();
        if (buffer.readableBytes() < length) {
            buffer.resetReaderIndex();
            return null;
        }
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        String str = new String(bytes);
        if (str.isEmpty()) {
            throw new RuntimeException("decode string is null or empty");
        }
        return str;
    }

    public static String decodeStringByte(ByteBuf buffer) {
        if (buffer.readableBytes() < 1) {
            return null;
        }
        buffer.markReaderIndex();
        short length = buffer.readByte();
        if (buffer.readableBytes() < length) {
            buffer.resetReaderIndex();
            return null;
        }
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        String str = new String(bytes);
        if (str.isEmpty()) {
            throw new RuntimeException("decode string is null or empty");
        }
        return str;
    }

    public static ByteBuf encodeStringInt(String string) {
        if (string == null || string.length() == 0) {
            throw new RuntimeException("encode string is null or empty");
        }
        ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.buffer(4 + string.length());
        byteBuf.writeInt(string.length());
        byteBuf.writeBytes(string.getBytes());
        return byteBuf;
    }
}

