/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.common.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskExecutor {
    private ExecutorService asyncTasks = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Thread::new);
    private ExecutorService bgTasks = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Thread::new);
    private Map<String, ConcurrentTask> concurrentTasks = Maps.newConcurrentMap();

    public static TaskExecutor instance() {
        return Singleton.INSTANCE;
    }

    private TaskExecutor() {
    }

    public <T> Task<T> async(Callable<T> callable) {
        return this.async(callable, null);
    }

    public <T> Task<T> async(Callable<T> callable, Failure failure) {
        Task task = new Task();
        task.future = this.asyncTasks.submit(callable);
        task.failure = failure;
        return task;
    }

    public BackgroundTask background(Callable<Void> callable) {
        return this.background(callable, null);
    }

    public BackgroundTask background(Callable<Void> callable, Failure failure) {
        BackgroundTask task = new BackgroundTask();
        task.future = this.bgTasks.submit(callable);
        task.failure = failure;
        return task;
    }

    public ConcurrentTask refConcurrent(String name, int parallelism) {
        ConcurrentTask task = this.concurrentTasks.get(name);
        if (task != null) {
            return task;
        }
        task = new ConcurrentTask(parallelism);
        this.concurrentTasks.put(name, task);
        return task;
    }

    public int getAsyncTaskCount() {
        return ((ThreadPoolExecutor)this.asyncTasks).getActiveCount();
    }

    public int getBgTaskCount() {
        return ((ThreadPoolExecutor)this.bgTasks).getActiveCount();
    }

    public int getConcurrentTaskCount() {
        int count = 0;
        for (ConcurrentTask t : this.concurrentTasks.values()) {
            count += ((ForkJoinPool)t.concurrentTasks).getActiveThreadCount();
        }
        return count;
    }

    public static class ConcurrentTask {
        private ExecutorService concurrentTasks;

        public ConcurrentTask(int parallelism) {
            this.concurrentTasks = new ForkJoinPool(Math.min(parallelism, Runtime.getRuntime().availableProcessors()), ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
        }

        public <T> Future<T> concurrent(Callable<T> callable) {
            return this.concurrentTasks.submit(callable);
        }
    }

    public static interface Failure {
        public void onError(Exception var1);
    }

    public static class BackgroundTask
    extends Task<Void> {
        @Override
        public void join() {
            block2: {
                try {
                    this.future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    if (this.failure == null) break block2;
                    this.failure.onError(e);
                }
            }
        }
    }

    public static class Task<T> {
        protected Future<T> future;
        protected Failure failure;

        public T get() {
            try {
                return this.future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (this.failure != null) {
                    this.failure.onError(e);
                }
                return null;
            }
        }

        public void join() {
            this.get();
        }
    }

    private static class Singleton {
        private static final TaskExecutor INSTANCE = new TaskExecutor();

        private Singleton() {
        }
    }
}

