/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.authentication;

import com.oceanbase.jdbc.authentication.AuthenticationPlugin;
import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.com.send.authentication.Sha256PasswordPlugin;
import com.oceanbase.jdbc.internal.io.input.PacketInputStream;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class CachingSha2PasswordPlugin
implements AuthenticationPlugin {
    public static final String TYPE = "caching_sha2_password";
    private String authenticationData;
    private byte[] seed;
    private Options options;

    public static byte[] sha256encryptPassword(String password, byte[] seed, String passwordCharacterEncoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (password == null || password.isEmpty()) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] bytePwd = passwordCharacterEncoding != null && !passwordCharacterEncoding.isEmpty() ? password.getBytes(passwordCharacterEncoding) : password.getBytes();
        byte[] stage1 = messageDigest.digest(bytePwd);
        messageDigest.reset();
        byte[] stage2 = messageDigest.digest(stage1);
        messageDigest.reset();
        messageDigest.update(stage2);
        messageDigest.update(seed);
        byte[] digest = messageDigest.digest();
        byte[] returnBytes = new byte[digest.length];
        for (int i = 0; i < digest.length; ++i) {
            returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
        }
        return returnBytes;
    }

    @Override
    public String name() {
        return "caching sha2 password";
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Options options) {
        this.seed = seed;
        this.authenticationData = authenticationData;
        this.options = options;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException, SQLException {
        if (this.authenticationData == null || this.authenticationData.isEmpty()) {
            out.writeEmptyPacket(sequence.incrementAndGet());
        } else {
            try {
                out.startPacket(sequence.incrementAndGet());
                byte[] truncatedSeed = this.seed.length > 0 ? Arrays.copyOfRange(this.seed, 0, this.seed.length - 1) : new byte[]{};
                out.write(CachingSha2PasswordPlugin.sha256encryptPassword(this.authenticationData, truncatedSeed, this.options.passwordCharacterEncoding));
                out.flush();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Could not use SHA-256, failing", e);
            }
        }
        Buffer buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        switch (buffer.getByteAt(0)) {
            case -1: 
            case 0: {
                return buffer;
            }
        }
        byte[] authResult = buffer.getLengthEncodedBytes();
        switch (authResult[0]) {
            case 3: {
                buffer = in.getPacket(true);
                sequence.set(in.getLastPacketSeq());
                return buffer;
            }
            case 4: {
                if (Boolean.TRUE.equals(this.options.useSsl)) {
                    out.startPacket(sequence.incrementAndGet());
                    byte[] bytePwd = this.options.passwordCharacterEncoding != null && !this.options.passwordCharacterEncoding.isEmpty() ? this.authenticationData.getBytes(this.options.passwordCharacterEncoding) : this.authenticationData.getBytes();
                    out.write(bytePwd);
                    out.write(0);
                    out.flush();
                } else {
                    PublicKey publicKey;
                    if (this.options.serverRsaPublicKeyFile != null && !this.options.serverRsaPublicKeyFile.isEmpty()) {
                        publicKey = Sha256PasswordPlugin.readPublicKeyFromFile(this.options.serverRsaPublicKeyFile);
                    } else {
                        if (!this.options.allowPublicKeyRetrieval) {
                            throw new SQLException("RSA public key is not available client side (option serverRsaPublicKeyFile not set)", "S1009");
                        }
                        out.startPacket(sequence.incrementAndGet());
                        out.write(2);
                        out.flush();
                        publicKey = Sha256PasswordPlugin.readPublicKeyFromSocket(in, sequence);
                    }
                    try {
                        byte[] cipherBytes = Sha256PasswordPlugin.encrypt(publicKey, this.authenticationData, this.seed, this.options.passwordCharacterEncoding);
                        out.startPacket(sequence.incrementAndGet());
                        out.write(cipherBytes);
                        out.flush();
                    }
                    catch (Exception ex) {
                        throw new SQLException("Could not connect using SHA256 plugin : " + ex.getMessage(), "S1009", ex);
                    }
                }
                buffer = in.getPacket(true);
                sequence.set(in.getLastPacketSeq());
                return buffer;
            }
        }
        throw new SQLException("Protocol exchange error. Expect login success or RSA login request message", "S1009");
    }
}

