/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.LongDataParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class OBReaderParameter
implements Cloneable,
LongDataParameterHolder {
    private final Clob clob;
    private final boolean hasLobLocator;
    private final byte[] lobLocatorBinary;
    private Reader reader;
    private long length;
    private final boolean noBackslashEscapes;

    public OBReaderParameter(Reader reader, long length, boolean noBackslashEscapes) {
        this.clob = null;
        this.hasLobLocator = false;
        this.lobLocatorBinary = null;
        this.reader = reader;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public OBReaderParameter(byte[] lobLocatorBinary, boolean noBackslashEscapes) {
        this.clob = null;
        this.hasLobLocator = true;
        this.lobLocatorBinary = lobLocatorBinary;
        this.reader = null;
        this.length = 0L;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public OBReaderParameter(Clob clob, boolean noBackslashEscapes) {
        this.clob = clob;
        this.hasLobLocator = false;
        this.lobLocatorBinary = null;
        this.reader = null;
        this.length = 0L;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    private void setReader() throws SQLException {
        if (this.clob != null) {
            this.reader = this.clob.getCharacterStream();
            this.length = this.clob.length();
        }
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException, SQLException {
        this.setReader();
        if (this.reader != null) {
            pos.write(39);
            if (this.length == Long.MAX_VALUE) {
                pos.writeEscapeQuote(this.reader, this.noBackslashEscapes);
            } else {
                pos.writeEscapeQuote(this.reader, this.length, this.noBackslashEscapes);
            }
            pos.write(39);
        }
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return -1;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException, SQLException {
        this.setReader();
        if (this.hasLobLocator && this.lobLocatorBinary != null) {
            pos.writeFieldLength(this.lobLocatorBinary.length);
            pos.write(this.lobLocatorBinary, 0, this.lobLocatorBinary.length);
        } else if (this.reader != null && this.length == Long.MAX_VALUE) {
            pos.write(this.reader, false, this.noBackslashEscapes);
        } else {
            pos.write(this.reader, this.length, false, this.noBackslashEscapes);
        }
    }

    @Override
    public ColumnType getColumnType() {
        return this.hasLobLocator ? ColumnType.ORA_CLOB : ColumnType.STRING;
    }

    @Override
    public String toString() {
        return "<Reader>";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return !this.hasLobLocator;
    }

    @Override
    public boolean writePieceData(PacketOutputStream writer, boolean first, Options options) throws IOException, SQLException {
        int piece;
        if (first) {
            this.setReader();
        }
        int pieceLen = options.pieceLength;
        char[] buffer = new char[pieceLen];
        int len = this.reader.read(buffer);
        boolean ret = false;
        if (len < 0) {
            writer.write(3);
            writer.write(0);
            writer.writeLong(0L);
            writer.flush();
            return false;
        }
        byte[] data = new String(buffer, 0, len).getBytes(options.getCharacterEncoding());
        if (first && this.reader.ready()) {
            piece = 1;
            ret = true;
        } else if (first && !this.reader.ready()) {
            piece = 3;
            ret = false;
        } else if (!first && this.reader.ready()) {
            piece = 2;
            ret = true;
        } else {
            piece = 3;
            ret = false;
        }
        writer.write(piece);
        writer.write(0);
        writer.writeLong(data.length);
        writer.write(data);
        writer.flush();
        return ret;
    }

    @Override
    public boolean writeLongData(PacketOutputStream pos, Options options, int statementId, short paramIndex) throws IOException {
        return false;
    }
}

